/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.partition;

import java.util.Collection;
import java.util.Collections;
import junit.framework.TestCase;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.taskexecutor.partition.PartitionTable;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class PartitionTableTest
extends TestLogger {
    private static final JobID JOB_ID = new JobID();
    private static final ResultPartitionID PARTITION_ID = new ResultPartitionID();

    @Test
    public void testEmptyTable() {
        PartitionTable table = new PartitionTable();
        Collection partitionsForNonExistingJob = table.stopTrackingPartitions((Object)JOB_ID);
        TestCase.assertNotNull((Object)partitionsForNonExistingJob);
        MatcherAssert.assertThat((Object)partitionsForNonExistingJob, (Matcher)Matchers.empty());
        Assert.assertFalse((boolean)table.hasTrackedPartitions((Object)JOB_ID));
    }

    @Test
    public void testStartTrackingPartition() {
        PartitionTable table = new PartitionTable();
        table.startTrackingPartitions((Object)JOB_ID, Collections.singletonList(PARTITION_ID));
        TestCase.assertTrue((boolean)table.hasTrackedPartitions((Object)JOB_ID));
    }

    @Test
    public void testStartTrackingZeroPartitionDoesNotMutateState() {
        PartitionTable table = new PartitionTable();
        table.startTrackingPartitions((Object)JOB_ID, Collections.emptyList());
        Assert.assertFalse((boolean)table.hasTrackedPartitions((Object)JOB_ID));
    }

    @Test
    public void testStopTrackingAllPartitions() {
        PartitionTable table = new PartitionTable();
        table.startTrackingPartitions((Object)JOB_ID, Collections.singletonList(PARTITION_ID));
        Collection storedPartitions = table.stopTrackingPartitions((Object)JOB_ID);
        MatcherAssert.assertThat((Object)storedPartitions, (Matcher)Matchers.contains((Object[])new ResultPartitionID[]{PARTITION_ID}));
        Assert.assertFalse((boolean)table.hasTrackedPartitions((Object)JOB_ID));
    }

    @Test
    public void testStopTrackingPartitions() {
        ResultPartitionID partitionId2 = new ResultPartitionID();
        PartitionTable table = new PartitionTable();
        table.startTrackingPartitions((Object)JOB_ID, Collections.singletonList(PARTITION_ID));
        table.startTrackingPartitions((Object)JOB_ID, Collections.singletonList(partitionId2));
        table.stopTrackingPartitions((Object)JOB_ID, Collections.singletonList(partitionId2));
        TestCase.assertTrue((boolean)table.hasTrackedPartitions((Object)JOB_ID));
        Collection storedPartitions = table.stopTrackingPartitions((Object)JOB_ID);
        MatcherAssert.assertThat((Object)storedPartitions, (Matcher)Matchers.contains((Object[])new ResultPartitionID[]{PARTITION_ID}));
        Assert.assertFalse((boolean)table.hasTrackedPartitions((Object)JOB_ID));
    }
}

