/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.function.BiConsumer;
import org.apache.flink.util.UserCodeClassLoader;

public class TestingUserCodeClassLoader
implements UserCodeClassLoader {
    private final ClassLoader classLoader;
    private final BiConsumer<String, Runnable> registerReleaseHookConsumer;

    public TestingUserCodeClassLoader(ClassLoader classLoader, BiConsumer<String, Runnable> registerReleaseHookConsumer) {
        this.classLoader = classLoader;
        this.registerReleaseHookConsumer = registerReleaseHookConsumer;
    }

    public ClassLoader asClassLoader() {
        return this.classLoader;
    }

    public void registerReleaseHookIfAbsent(String releaseHookName, Runnable releaseHook) {
        this.registerReleaseHookConsumer.accept(releaseHookName, releaseHook);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private ClassLoader classLoader = Builder.class.getClassLoader();
        private BiConsumer<String, Runnable> registerReleaseHookConsumer = (ign, ore) -> {};

        private Builder() {
        }

        public Builder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder setRegisterReleaseHookConsumer(BiConsumer<String, Runnable> registerReleaseHookConsumer) {
            this.registerReleaseHookConsumer = registerReleaseHookConsumer;
            return this;
        }

        public TestingUserCodeClassLoader build() {
            return new TestingUserCodeClassLoader(this.classLoader, this.registerReleaseHookConsumer);
        }
    }
}

