/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestExecutorFactory;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.jobgraph.tasks.TaskOperatorEventGateway;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.SharedResources;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.taskexecutor.GlobalAggregateManager;
import org.apache.flink.runtime.taskmanager.TaskManagerActions;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.util.UserCodeClassLoader;

public interface Environment {
    public ExecutionConfig getExecutionConfig();

    public JobID getJobID();

    public JobVertexID getJobVertexId();

    public ExecutionAttemptID getExecutionId();

    public Configuration getTaskConfiguration();

    public TaskManagerRuntimeInfo getTaskManagerInfo();

    public TaskMetricGroup getMetricGroup();

    public Configuration getJobConfiguration();

    public TaskInfo getTaskInfo();

    public InputSplitProvider getInputSplitProvider();

    public TaskOperatorEventGateway getOperatorCoordinatorEventGateway();

    public IOManager getIOManager();

    public MemoryManager getMemoryManager();

    public SharedResources getSharedResources();

    public UserCodeClassLoader getUserCodeClassLoader();

    public Map<String, Future<Path>> getDistributedCacheEntries();

    public BroadcastVariableManager getBroadcastVariableManager();

    public TaskStateManager getTaskStateManager();

    public GlobalAggregateManager getGlobalAggregateManager();

    public ExternalResourceInfoProvider getExternalResourceInfoProvider();

    public AccumulatorRegistry getAccumulatorRegistry();

    public TaskKvStateRegistry getTaskKvStateRegistry();

    public void acknowledgeCheckpoint(long var1, CheckpointMetrics var3);

    public void acknowledgeCheckpoint(long var1, CheckpointMetrics var3, TaskStateSnapshot var4);

    public void declineCheckpoint(long var1, CheckpointException var3);

    public void failExternally(Throwable var1);

    public ResultPartitionWriter getWriter(int var1);

    public ResultPartitionWriter[] getAllWriters();

    public IndexedInputGate getInputGate(int var1);

    public IndexedInputGate[] getAllInputGates();

    public TaskEventDispatcher getTaskEventDispatcher();

    public TaskManagerActions getTaskManagerActions();

    default public void setMainMailboxExecutor(MailboxExecutor mainMailboxExecutor) {
    }

    default public MailboxExecutor getMainMailboxExecutor() {
        throw new UnsupportedOperationException();
    }

    default public void setAsyncOperationsThreadPool(ExecutorService executorService) {
    }

    default public ExecutorService getAsyncOperationsThreadPool() {
        throw new UnsupportedOperationException();
    }

    default public void setCheckpointStorageAccess(CheckpointStorageAccess checkpointStorageAccess) {
    }

    default public CheckpointStorageAccess getCheckpointStorageAccess() {
        throw new UnsupportedOperationException();
    }

    public ChannelStateWriteRequestExecutorFactory getChannelStateExecutorFactory();
}

