/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote;

import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.SegmentPartitionFile;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierMasterAgent;

public class RemoteTierMasterAgent
implements TierMasterAgent {
    private final TieredStorageResourceRegistry resourceRegistry;
    private final String remoteStorageBasePath;

    RemoteTierMasterAgent(String remoteStorageBasePath, TieredStorageResourceRegistry resourceRegistry) {
        this.remoteStorageBasePath = remoteStorageBasePath;
        this.resourceRegistry = resourceRegistry;
    }

    @Override
    public void addPartition(TieredStoragePartitionId partitionID) {
        this.resourceRegistry.registerResource(partitionID, () -> SegmentPartitionFile.deletePathQuietly(SegmentPartitionFile.getPartitionPath(partitionID, this.remoteStorageBasePath)));
    }

    @Override
    public void releasePartition(TieredStoragePartitionId partitionID) {
        this.resourceRegistry.clearResourceFor(partitionID);
    }
}

