/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class InputChannelTest {
    InputChannelTest() {
    }

    @Test
    void testExponentialBackoff() {
        InputChannel ch = this.createInputChannel(500, 4000);
        Assertions.assertThat((int)ch.getCurrentBackoff()).isZero();
        Assertions.assertThat((boolean)ch.increaseBackoff()).isTrue();
        Assertions.assertThat((int)ch.getCurrentBackoff()).isEqualTo(500);
        Assertions.assertThat((boolean)ch.increaseBackoff()).isTrue();
        Assertions.assertThat((int)ch.getCurrentBackoff()).isEqualTo(1000);
        Assertions.assertThat((boolean)ch.increaseBackoff()).isTrue();
        Assertions.assertThat((int)ch.getCurrentBackoff()).isEqualTo(2000);
        Assertions.assertThat((boolean)ch.increaseBackoff()).isTrue();
        Assertions.assertThat((int)ch.getCurrentBackoff()).isEqualTo(4000);
        Assertions.assertThat((boolean)ch.increaseBackoff()).isFalse();
        Assertions.assertThat((int)ch.getCurrentBackoff()).isEqualTo(4000);
    }

    @Test
    void testExponentialBackoffCappedAtMax() {
        InputChannel ch = this.createInputChannel(500, 3000);
        Assertions.assertThat((int)ch.getCurrentBackoff()).isZero();
        Assertions.assertThat((boolean)ch.increaseBackoff()).isTrue();
        Assertions.assertThat((int)ch.getCurrentBackoff()).isEqualTo(500);
        Assertions.assertThat((boolean)ch.increaseBackoff()).isTrue();
        Assertions.assertThat((int)ch.getCurrentBackoff()).isEqualTo(1000);
        Assertions.assertThat((boolean)ch.increaseBackoff()).isTrue();
        Assertions.assertThat((int)ch.getCurrentBackoff()).isEqualTo(2000);
        Assertions.assertThat((boolean)ch.increaseBackoff()).isTrue();
        Assertions.assertThat((int)ch.getCurrentBackoff()).isEqualTo(3000);
        Assertions.assertThat((boolean)ch.increaseBackoff()).isFalse();
        Assertions.assertThat((int)ch.getCurrentBackoff()).isEqualTo(3000);
    }

    @Test
    void testExponentialBackoffSingle() {
        InputChannel ch = this.createInputChannel(500, 500);
        Assertions.assertThat((int)ch.getCurrentBackoff()).isZero();
        Assertions.assertThat((boolean)ch.increaseBackoff()).isTrue();
        Assertions.assertThat((int)ch.getCurrentBackoff()).isEqualTo(500);
        Assertions.assertThat((boolean)ch.increaseBackoff()).isFalse();
        Assertions.assertThat((int)ch.getCurrentBackoff()).isEqualTo(500);
    }

    @Test
    void testExponentialNoBackoff() {
        InputChannel ch = this.createInputChannel(0, 0);
        Assertions.assertThat((int)ch.getCurrentBackoff()).isZero();
        Assertions.assertThat((boolean)ch.increaseBackoff()).isFalse();
        Assertions.assertThat((int)ch.getCurrentBackoff()).isZero();
    }

    private InputChannel createInputChannel(int initialBackoff, int maxBackoff) {
        return new MockInputChannel((SingleInputGate)Mockito.mock(SingleInputGate.class), 0, new ResultPartitionID(), initialBackoff, maxBackoff);
    }

    private static class MockInputChannel
    extends InputChannel {
        private MockInputChannel(SingleInputGate inputGate, int channelIndex, ResultPartitionID partitionId, int initialBackoff, int maxBackoff) {
            super(inputGate, channelIndex, partitionId, new ResultSubpartitionIndexSet(0), initialBackoff, maxBackoff, (Counter)new SimpleCounter(), (Counter)new SimpleCounter());
        }

        public void resumeConsumption() {
        }

        public void acknowledgeAllRecordsProcessed() throws IOException {
        }

        void requestSubpartitions() throws IOException, InterruptedException {
        }

        protected int peekNextBufferSubpartitionIdInternal() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Optional<InputChannel.BufferAndAvailability> getNextBuffer() throws IOException, InterruptedException {
            return Optional.empty();
        }

        void sendTaskEvent(TaskEvent event) throws IOException {
        }

        boolean isReleased() {
            return false;
        }

        void releaseAllResources() throws IOException {
        }

        void announceBufferSize(int newBufferSize) {
        }

        int getBuffersInUseCount() {
            return 0;
        }
    }
}

