/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.jobmaster.DefaultExecutionDeploymentReconciler;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentReconciliationHandler;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentState;
import org.apache.flink.runtime.taskexecutor.ExecutionDeploymentReport;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultExecutionDeploymentReconcilerTest {
    DefaultExecutionDeploymentReconcilerTest() {
    }

    @Test
    void testMatchingDeployments() {
        TestingExecutionDeploymentReconciliationHandler handler = new TestingExecutionDeploymentReconciliationHandler();
        DefaultExecutionDeploymentReconciler reconciler = new DefaultExecutionDeploymentReconciler((ExecutionDeploymentReconciliationHandler)handler);
        ResourceID resourceId = ResourceID.generate();
        ExecutionAttemptID attemptId = ExecutionGraphTestUtils.createExecutionAttemptId();
        reconciler.reconcileExecutionDeployments(resourceId, new ExecutionDeploymentReport(Collections.singleton(attemptId)), Collections.singletonMap(attemptId, ExecutionDeploymentState.DEPLOYED));
        Assertions.assertThat(handler.getMissingExecutions()).isEmpty();
        Assertions.assertThat(handler.getUnknownExecutions()).isEmpty();
    }

    @Test
    void testMissingDeployments() {
        TestingExecutionDeploymentReconciliationHandler handler = new TestingExecutionDeploymentReconciliationHandler();
        DefaultExecutionDeploymentReconciler reconciler = new DefaultExecutionDeploymentReconciler((ExecutionDeploymentReconciliationHandler)handler);
        ResourceID resourceId = ResourceID.generate();
        ExecutionAttemptID attemptId = ExecutionGraphTestUtils.createExecutionAttemptId();
        reconciler.reconcileExecutionDeployments(resourceId, new ExecutionDeploymentReport(Collections.emptySet()), Collections.singletonMap(attemptId, ExecutionDeploymentState.DEPLOYED));
        Assertions.assertThat(handler.getUnknownExecutions()).isEmpty();
        Assertions.assertThat(handler.getMissingExecutions()).contains((Object[])new ExecutionAttemptID[]{attemptId});
    }

    @Test
    void testUnknownDeployments() {
        TestingExecutionDeploymentReconciliationHandler handler = new TestingExecutionDeploymentReconciliationHandler();
        DefaultExecutionDeploymentReconciler reconciler = new DefaultExecutionDeploymentReconciler((ExecutionDeploymentReconciliationHandler)handler);
        ResourceID resourceId = ResourceID.generate();
        ExecutionAttemptID attemptId = ExecutionGraphTestUtils.createExecutionAttemptId();
        reconciler.reconcileExecutionDeployments(resourceId, new ExecutionDeploymentReport(Collections.singleton(attemptId)), Collections.emptyMap());
        Assertions.assertThat(handler.getMissingExecutions()).isEmpty();
        Assertions.assertThat(handler.getUnknownExecutions()).contains((Object[])new ExecutionAttemptID[]{attemptId});
    }

    @Test
    void testMissingAndUnknownDeployments() {
        TestingExecutionDeploymentReconciliationHandler handler = new TestingExecutionDeploymentReconciliationHandler();
        DefaultExecutionDeploymentReconciler reconciler = new DefaultExecutionDeploymentReconciler((ExecutionDeploymentReconciliationHandler)handler);
        ResourceID resourceId = ResourceID.generate();
        ExecutionAttemptID unknownId = ExecutionGraphTestUtils.createExecutionAttemptId();
        ExecutionAttemptID missingId = ExecutionGraphTestUtils.createExecutionAttemptId();
        ExecutionAttemptID matchingId = ExecutionGraphTestUtils.createExecutionAttemptId();
        reconciler.reconcileExecutionDeployments(resourceId, new ExecutionDeploymentReport(new HashSet<ExecutionAttemptID>(Arrays.asList(unknownId, matchingId))), Stream.of(missingId, matchingId).collect(Collectors.toMap(x -> x, x -> ExecutionDeploymentState.DEPLOYED)));
        Assertions.assertThat(handler.getMissingExecutions()).contains((Object[])new ExecutionAttemptID[]{missingId});
        Assertions.assertThat(handler.getUnknownExecutions()).contains((Object[])new ExecutionAttemptID[]{unknownId});
    }

    @Test
    void testPendingDeployments() {
        TestingExecutionDeploymentReconciliationHandler handler = new TestingExecutionDeploymentReconciliationHandler();
        DefaultExecutionDeploymentReconciler reconciler = new DefaultExecutionDeploymentReconciler((ExecutionDeploymentReconciliationHandler)handler);
        ResourceID resourceId = ResourceID.generate();
        ExecutionAttemptID matchingId = ExecutionGraphTestUtils.createExecutionAttemptId();
        ExecutionAttemptID unknownId = ExecutionGraphTestUtils.createExecutionAttemptId();
        ExecutionAttemptID missingId = ExecutionGraphTestUtils.createExecutionAttemptId();
        reconciler.reconcileExecutionDeployments(resourceId, new ExecutionDeploymentReport(new HashSet<ExecutionAttemptID>(Arrays.asList(matchingId, unknownId))), Stream.of(matchingId, missingId).collect(Collectors.toMap(x -> x, x -> ExecutionDeploymentState.PENDING)));
        Assertions.assertThat(handler.getMissingExecutions()).isEmpty();
        Assertions.assertThat(handler.getUnknownExecutions()).contains((Object[])new ExecutionAttemptID[]{unknownId});
    }

    private static class TestingExecutionDeploymentReconciliationHandler
    implements ExecutionDeploymentReconciliationHandler {
        private final Collection<ExecutionAttemptID> missingExecutions = new ArrayList<ExecutionAttemptID>();
        private final Collection<ExecutionAttemptID> unknownExecutions = new ArrayList<ExecutionAttemptID>();

        private TestingExecutionDeploymentReconciliationHandler() {
        }

        public void onMissingDeploymentsOf(Collection<ExecutionAttemptID> executionAttemptIds, ResourceID hostingTaskExecutor) {
            this.missingExecutions.addAll(executionAttemptIds);
        }

        public void onUnknownDeploymentsOf(Collection<ExecutionAttemptID> executionAttemptIds, ResourceID hostingTaskExecutor) {
            this.unknownExecutions.addAll(executionAttemptIds);
        }

        public Collection<ExecutionAttemptID> getMissingExecutions() {
            return this.missingExecutions;
        }

        public Collection<ExecutionAttemptID> getUnknownExecutions() {
            return this.unknownExecutions;
        }
    }
}

