/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.executiongraph.TestingComponentMainThreadExecutor;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridge;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridgeBuilder;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.util.function.SupplierWithException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class SlotPoolInteractionsTest {
    private static final Time fastTimeout = Time.milliseconds((long)1L);
    @RegisterExtension
    private static final TestingComponentMainThreadExecutor.Extension EXECUTOR_EXTENSION = new TestingComponentMainThreadExecutor.Extension(10L);
    private final TestingComponentMainThreadExecutor testMainThreadExecutor = EXECUTOR_EXTENSION.getComponentMainThreadTestExecutor();

    SlotPoolInteractionsTest() {
    }

    @Test
    void testSlotAllocationNoResourceManager() throws Exception {
        try (DeclarativeSlotPoolBridge pool = this.createAndSetUpSlotPoolWithoutResourceManager();){
            CompletableFuture future = (CompletableFuture)this.testMainThreadExecutor.execute(() -> SlotPoolInteractionsTest.lambda$testSlotAllocationNoResourceManager$0((SlotPool)pool));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(future::get).withFailMessage("We expected an ExecutionException.", new Object[0])).isInstanceOf(ExecutionException.class)).hasCauseInstanceOf(TimeoutException.class);
        }
    }

    @Test
    void testCancelSlotAllocationWithoutResourceManager() throws Exception {
        try (DeclarativeSlotPoolBridge pool = this.createAndSetUpSlotPoolWithoutResourceManager();){
            CompletableFuture future = (CompletableFuture)this.testMainThreadExecutor.execute(() -> pool.requestNewAllocatedSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, fastTimeout));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(future::get).withFailMessage("We expected a TimeoutException.", new Object[0])).isInstanceOf(ExecutionException.class)).hasCauseInstanceOf(TimeoutException.class);
            CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> pool.getNumPendingRequests() == 0));
        }
    }

    @Test
    void testSlotAllocationTimeout() throws Exception {
        try (DeclarativeSlotPoolBridge pool = this.createAndSetUpSlotPool();){
            CompletableFuture future = (CompletableFuture)this.testMainThreadExecutor.execute(() -> pool.requestNewAllocatedSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, fastTimeout));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(future::get).withFailMessage("We expected a TimeoutException.", new Object[0])).isInstanceOf(ExecutionException.class)).hasCauseInstanceOf(TimeoutException.class);
            CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> pool.getNumPendingRequests() == 0));
        }
    }

    private DeclarativeSlotPoolBridge createAndSetUpSlotPool() throws Exception {
        return new DeclarativeSlotPoolBridgeBuilder().buildAndStart(this.testMainThreadExecutor.getMainThreadExecutor());
    }

    private DeclarativeSlotPoolBridge createAndSetUpSlotPoolWithoutResourceManager() throws Exception {
        return new DeclarativeSlotPoolBridgeBuilder().setResourceManagerGateway(null).buildAndStart(this.testMainThreadExecutor.getMainThreadExecutor());
    }

    private static /* synthetic */ CompletableFuture lambda$testSlotAllocationNoResourceManager$0(SlotPool pool) throws Throwable {
        return pool.requestNewAllocatedSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, fastTimeout);
    }
}

