/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import java.util.function.Consumer;
import org.apache.flink.runtime.leaderelection.LeaderContender;

public class TestingGenericLeaderContender
implements LeaderContender {
    private final Object lock = new Object();
    private final Consumer<UUID> grantLeadershipConsumer;
    private final Runnable revokeLeadershipRunnable;
    private final Consumer<Exception> handleErrorConsumer;

    private TestingGenericLeaderContender(Consumer<UUID> grantLeadershipConsumer, Runnable revokeLeadershipRunnable, Consumer<Exception> handleErrorConsumer) {
        this.grantLeadershipConsumer = grantLeadershipConsumer;
        this.revokeLeadershipRunnable = revokeLeadershipRunnable;
        this.handleErrorConsumer = handleErrorConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantLeadership(UUID leaderSessionID) {
        Object object = this.lock;
        synchronized (object) {
            this.grantLeadershipConsumer.accept(leaderSessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeLeadership() {
        Object object = this.lock;
        synchronized (object) {
            this.revokeLeadershipRunnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(Exception exception) {
        Object object = this.lock;
        synchronized (object) {
            this.handleErrorConsumer.accept(exception);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Consumer<UUID> grantLeadershipConsumer = ignoredSessionID -> {};
        private Runnable revokeLeadershipRunnable = () -> {};
        private Consumer<Exception> handleErrorConsumer = error -> {
            throw new AssertionError(error);
        };

        private Builder() {
        }

        public Builder setGrantLeadershipConsumer(Consumer<UUID> grantLeadershipConsumer) {
            this.grantLeadershipConsumer = grantLeadershipConsumer;
            return this;
        }

        public Builder setRevokeLeadershipRunnable(Runnable revokeLeadershipRunnable) {
            this.revokeLeadershipRunnable = revokeLeadershipRunnable;
            return this;
        }

        public Builder setHandleErrorConsumer(Consumer<Exception> handleErrorConsumer) {
            this.handleErrorConsumer = handleErrorConsumer;
            return this;
        }

        public TestingGenericLeaderContender build() {
            return new TestingGenericLeaderContender(this.grantLeadershipConsumer, this.revokeLeadershipRunnable, this.handleErrorConsumer);
        }
    }
}

