/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.runtime.scheduler.DefaultVertexParallelismInfo;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultVertexParallelismInfoTest {
    private static final Function<Integer, Optional<String>> ALWAYS_VALID = max -> Optional.empty();

    DefaultVertexParallelismInfoTest() {
    }

    @Test
    void parallelismInvalid() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultVertexParallelismInfo(-2, 1, ALWAYS_VALID)).withFailMessage("parallelism is not in valid bounds", new Object[0])).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void parallelismValid() {
        new DefaultVertexParallelismInfo(10, 1, ALWAYS_VALID);
        new DefaultVertexParallelismInfo(-1, 1, ALWAYS_VALID);
    }

    @Test
    void maxParallelismInvalid() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultVertexParallelismInfo(1, -1, ALWAYS_VALID)).withFailMessage("max parallelism is not in valid bounds", new Object[0])).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testSetParallelism() {
        DefaultVertexParallelismInfo info = new DefaultVertexParallelismInfo(-1, 10, ALWAYS_VALID);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> info.setParallelism(-1)).withFailMessage("parallelism is not in valid bounds", new Object[0])).isInstanceOf(IllegalArgumentException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> info.setParallelism(11)).withFailMessage("Vertex's parallelism should be smaller than or equal to vertex's max parallelism.", new Object[0])).isInstanceOf(IllegalArgumentException.class);
        info.setParallelism(5);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> info.setParallelism(5)).withFailMessage("Vertex's parallelism can be set only if the vertex's parallelism was not decided yet.", new Object[0])).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void setAutoMax() {
        DefaultVertexParallelismInfo info = new DefaultVertexParallelismInfo(1, Integer.MAX_VALUE, ALWAYS_VALID);
        Assertions.assertThat((int)info.getMaxParallelism()).isEqualTo(32768);
    }

    @Test
    void canRescaleMaxOutOfBounds() {
        DefaultVertexParallelismInfo info = new DefaultVertexParallelismInfo(1, 1, ALWAYS_VALID);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> info.canRescaleMaxParallelism(-4)).withFailMessage("not in valid bounds", new Object[0])).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void canRescaleMaxAuto() {
        DefaultVertexParallelismInfo info = new DefaultVertexParallelismInfo(1, 1, ALWAYS_VALID);
        Assertions.assertThat((boolean)info.canRescaleMaxParallelism(Integer.MAX_VALUE)).isTrue();
    }

    @Test
    void canRescaleMax() {
        DefaultVertexParallelismInfo info = new DefaultVertexParallelismInfo(1, 1, ALWAYS_VALID);
        Assertions.assertThat((boolean)info.canRescaleMaxParallelism(3)).isTrue();
    }

    @Test
    void canRescaleMaxDefault() {
        DefaultVertexParallelismInfo info = new DefaultVertexParallelismInfo(1, 1, ALWAYS_VALID);
        Assertions.assertThat((boolean)info.canRescaleMaxParallelism(-1)).isFalse();
    }

    @Test
    void setMaxOutOfBounds() {
        DefaultVertexParallelismInfo info = new DefaultVertexParallelismInfo(1, 1, ALWAYS_VALID);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> info.setMaxParallelism(-4)).withFailMessage("not in valid bounds", new Object[0])).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void setMaxInvalid() {
        DefaultVertexParallelismInfo info = new DefaultVertexParallelismInfo(1, 1, max -> Optional.of("not valid"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> info.setMaxParallelism(4)).withFailMessage("not valid", new Object[0])).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void setMaxValid() {
        DefaultVertexParallelismInfo info = new DefaultVertexParallelismInfo(1, 1, ALWAYS_VALID);
        info.setMaxParallelism(40);
        Assertions.assertThat((int)info.getMaxParallelism()).isEqualTo(40);
    }
}

