/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.scheduler.SchedulerBase;
import org.apache.flink.runtime.scheduler.VertexParallelismInformation;
import org.apache.flink.runtime.scheduler.VertexParallelismStore;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class SchedulerBaseComputeVertexParallelismTest {
    @Parameter
    private int parallelism;
    @Parameter(value=1)
    private int maxParallelism;
    @Parameter(value=2)
    private int expectedMaxParallelism;
    @Parameter(value=3)
    private int maxToScaleTo;
    @Parameter(value=4)
    private boolean expectedCanRescaleTo;

    SchedulerBaseComputeVertexParallelismTest() {
    }

    @Parameters(name="parallelism = {0}, maxParallelism = {1}, expected max = {2}, rescale to = {3}, can rescale = {4}")
    private static Collection<Object[]> data() {
        return Arrays.asList({1, -1, 128, 3, true}, {171, -1, 256, 42, true}, {172, -1, 512, 174, true}, {32768, -1, 32768, 32768, true}, {4, 32768, 32768, 3, false}, {4, 7, 7, 32768, false});
    }

    @TestTemplate
    void testMaxParallelismDefaulting() {
        JobVertex jobVertex = ExecutionGraphTestUtils.createNoOpVertex("test", this.parallelism, this.maxParallelism);
        VertexParallelismStore store = SchedulerBase.computeVertexParallelismStore(Collections.singleton(jobVertex));
        VertexParallelismInformation info = store.getParallelismInfo(jobVertex.getID());
        ((AbstractIntegerAssert)Assertions.assertThat((int)info.getParallelism()).as("constant parallelism", new Object[0])).isEqualTo(this.parallelism);
        ((AbstractIntegerAssert)Assertions.assertThat((int)info.getMaxParallelism()).as("expected max", new Object[0])).isEqualTo(this.expectedMaxParallelism);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)info.canRescaleMaxParallelism(this.maxToScaleTo)).as("can rescale max", new Object[0])).isEqualTo(this.expectedCanRescaleTo);
    }
}

