/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.token;

import java.util.Optional;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.security.token.DelegationTokenProvider;

public class ExceptionThrowingDelegationTokenProvider
implements DelegationTokenProvider {
    public static volatile ThreadLocal<Boolean> throwInInit = ThreadLocal.withInitial(() -> Boolean.FALSE);
    public static volatile ThreadLocal<Boolean> throwInUsage = ThreadLocal.withInitial(() -> Boolean.FALSE);
    public static volatile ThreadLocal<Boolean> addToken = ThreadLocal.withInitial(() -> Boolean.FALSE);
    public static volatile ThreadLocal<Boolean> constructed = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public static void reset() {
        throwInInit.set(false);
        throwInUsage.set(false);
        addToken.set(false);
        constructed.set(false);
    }

    public ExceptionThrowingDelegationTokenProvider() {
        constructed.set(true);
    }

    public String serviceName() {
        return "throw";
    }

    public void init(Configuration configuration) {
        if (throwInInit.get().booleanValue()) {
            throw new IllegalArgumentException();
        }
    }

    public boolean delegationTokensRequired() {
        if (throwInUsage.get().booleanValue()) {
            throw new IllegalArgumentException();
        }
        return addToken.get();
    }

    public DelegationTokenProvider.ObtainedDelegationTokens obtainDelegationTokens() {
        if (throwInUsage.get().booleanValue()) {
            throw new IllegalArgumentException();
        }
        if (addToken.get().booleanValue()) {
            return new DelegationTokenProvider.ObtainedDelegationTokens("TEST_TOKEN_VALUE".getBytes(), Optional.empty());
        }
        return null;
    }
}

