/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.CompositeStateHandle;
import org.apache.flink.runtime.state.KeyGroupsStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.util.concurrent.FutureUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StateUtilTest {
    StateUtilTest() {
    }

    @Test
    void testDiscardStateSize() throws Exception {
        Assertions.assertThat((Object)StateUtil.discardStateFuture(CompletableFuture.completedFuture(new TestStateObject(1234, 123)))).isEqualTo((Object)Tuple2.of((Object)1234L, (Object)123L));
        Tuple2 zeroSize = Tuple2.of((Object)0L, (Object)0L);
        Assertions.assertThat((Object)StateUtil.discardStateFuture(null)).isEqualTo((Object)zeroSize);
        Assertions.assertThat((Object)StateUtil.discardStateFuture(new CompletableFuture())).isEqualTo((Object)zeroSize);
        Assertions.assertThat((Object)StateUtil.discardStateFuture((Future)FutureUtils.completedExceptionally((Throwable)new RuntimeException()))).isEqualTo((Object)zeroSize);
        Assertions.assertThat((Object)StateUtil.discardStateFuture(StateUtilTest.emptyFuture(false, true))).isEqualTo((Object)zeroSize);
        Assertions.assertThat((Object)StateUtil.discardStateFuture(StateUtilTest.emptyFuture(false, false))).isEqualTo((Object)zeroSize);
        Assertions.assertThat((Object)StateUtil.discardStateFuture(StateUtilTest.emptyFuture(true, true))).isEqualTo((Object)zeroSize);
        Assertions.assertThat((Object)StateUtil.discardStateFuture(StateUtilTest.emptyFuture(true, false))).isEqualTo((Object)zeroSize);
    }

    @Test
    void unexpectedStateExceptionForSingleExpectedType() {
        RuntimeException exception = StateUtil.unexpectedStateHandleException(KeyGroupsStateHandle.class, KeyGroupsStateHandle.class);
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"Unexpected state handle type, expected one of: class org.apache.flink.runtime.state.KeyGroupsStateHandle, but found: class org.apache.flink.runtime.state.KeyGroupsStateHandle. This can mostly happen when a different StateBackend from the one that was used for taking a checkpoint/savepoint is used when restoring."});
    }

    @Test
    void unexpectedStateExceptionForMultipleExpectedTypes() {
        RuntimeException exception = StateUtil.unexpectedStateHandleException((Class[])new Class[]{KeyGroupsStateHandle.class, KeyGroupsStateHandle.class}, KeyGroupsStateHandle.class);
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"Unexpected state handle type, expected one of: class org.apache.flink.runtime.state.KeyGroupsStateHandle, class org.apache.flink.runtime.state.KeyGroupsStateHandle, but found: class org.apache.flink.runtime.state.KeyGroupsStateHandle. This can mostly happen when a different StateBackend from the one that was used for taking a checkpoint/savepoint is used when restoring."});
    }

    private static <T> Future<T> emptyFuture(final boolean done, final boolean canBeCancelled) {
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return canBeCancelled;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return done;
            }

            @Override
            public T get() {
                throw new UnsupportedOperationException();
            }

            @Override
            public T get(long timeout, TimeUnit unit) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class TestStateObject
    implements CompositeStateHandle {
        private static final long serialVersionUID = -8070326169926626355L;
        private final int size;
        private final int checkpointedSize;

        private TestStateObject(int size, int checkpointedSize) {
            this.size = size;
            this.checkpointedSize = checkpointedSize;
        }

        public long getStateSize() {
            return this.size;
        }

        public void discardState() {
        }

        public long getCheckpointedSize() {
            return this.checkpointedSize;
        }

        public void registerSharedStates(SharedStateRegistry stateRegistry, long checkpointID) {
            throw new UnsupportedOperationException();
        }
    }
}

