/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.StateRecoveryOptions;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.PreviousAllocationSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.util.SlotSelectionStrategyUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SlotSelectionStrategyUtilsTest {
    SlotSelectionStrategyUtilsTest() {
    }

    @Test
    void testCreatePreviousAllocationSlotSelectionStrategyForLocalRecoveryStreamingJob() {
        Configuration configuration = new Configuration();
        configuration.set(StateRecoveryOptions.LOCAL_RECOVERY, (Object)true);
        SlotSelectionStrategy slotSelectionStrategy = SlotSelectionStrategyUtils.selectSlotSelectionStrategy((JobType)JobType.STREAMING, (Configuration)configuration);
        Assertions.assertThat((Object)slotSelectionStrategy).isInstanceOf(PreviousAllocationSlotSelectionStrategy.class);
    }

    @Test
    void testCreateLocationPreferenceSlotSelectionStrategyForLocalRecoveryBatchJob() {
        Configuration configuration = new Configuration();
        configuration.set(StateRecoveryOptions.LOCAL_RECOVERY, (Object)true);
        SlotSelectionStrategy slotSelectionStrategy = SlotSelectionStrategyUtils.selectSlotSelectionStrategy((JobType)JobType.BATCH, (Configuration)configuration);
        Assertions.assertThat((Object)slotSelectionStrategy).isInstanceOf(LocationPreferenceSlotSelectionStrategy.class);
    }
}

