/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.factories;

import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.apache.flink.runtime.jobmaster.DefaultJobMasterServiceProcess;
import org.apache.flink.runtime.jobmaster.JobMasterServiceProcess;
import org.apache.flink.runtime.jobmaster.factories.JobMasterServiceFactory;
import org.apache.flink.runtime.jobmaster.factories.JobMasterServiceProcessFactory;

public class DefaultJobMasterServiceProcessFactory
implements JobMasterServiceProcessFactory {
    private final JobID jobId;
    private final String jobName;
    private final JobType jobType;
    @Nullable
    private final JobCheckpointingSettings checkpointingSettings;
    private final long initializationTimestamp;
    private final JobMasterServiceFactory jobMasterServiceFactory;

    public DefaultJobMasterServiceProcessFactory(JobID jobId, String jobName, JobType jobType, @Nullable JobCheckpointingSettings checkpointingSettings, long initializationTimestamp, JobMasterServiceFactory jobMasterServiceFactory) {
        this.jobId = jobId;
        this.jobName = jobName;
        this.jobType = jobType;
        this.checkpointingSettings = checkpointingSettings;
        this.initializationTimestamp = initializationTimestamp;
        this.jobMasterServiceFactory = jobMasterServiceFactory;
    }

    @Override
    public JobMasterServiceProcess create(UUID leaderSessionId) {
        return new DefaultJobMasterServiceProcess(this.jobId, leaderSessionId, this.jobMasterServiceFactory, cause -> this.createArchivedExecutionGraph(JobStatus.FAILED, (Throwable)cause));
    }

    @Override
    public JobID getJobId() {
        return this.jobId;
    }

    @Override
    public ArchivedExecutionGraph createArchivedExecutionGraph(JobStatus jobStatus, @Nullable Throwable cause) {
        return ArchivedExecutionGraph.createSparseArchivedExecutionGraph(this.jobId, this.jobName, jobStatus, this.jobType, cause, this.checkpointingSettings, this.initializationTimestamp);
    }
}

