/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing.declare;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.runtime.asyncprocessing.declare.DeclarationManager;

public class ContextVariable<T> {
    final DeclarationManager manager;
    final int ordinal;
    @Nullable
    final Supplier<T> initializer;
    boolean initialized = false;

    ContextVariable(DeclarationManager manager, int ordinal, Supplier<T> initializer) {
        this.manager = manager;
        this.ordinal = ordinal;
        this.initializer = initializer;
    }

    public T get() {
        if (!this.initialized && this.initializer != null) {
            this.manager.setVariableValue(this.ordinal, this.initializer.get());
            this.initialized = true;
        }
        return this.manager.getVariableValue(this.ordinal);
    }

    public void set(T newValue) {
        this.initialized = true;
        this.manager.setVariableValue(this.ordinal, newValue);
    }
}

