/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.FailedCheckpointStats;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;

public class PendingCheckpointStats
extends AbstractCheckpointStats {
    private static final long serialVersionUID = -973959257699390327L;
    private volatile int currentNumAcknowledgedSubtasks;
    private volatile long currentStateSize;
    private volatile long currentCheckpointedSize;
    private volatile long currentProcessedData;
    private volatile long currentPersistedData;
    private volatile boolean unalignedCheckpoint;
    private volatile SubtaskStateStats latestAcknowledgedSubtask;

    PendingCheckpointStats(long checkpointId, long triggerTimestamp, CheckpointProperties props, Map<JobVertexID, Integer> taskStats) {
        this(checkpointId, triggerTimestamp, props, taskStats.values().stream().mapToInt(i -> i).sum(), (Map<JobVertexID, TaskStateStats>)taskStats.entrySet().stream().collect(Collectors.toConcurrentMap(Map.Entry::getKey, e -> new TaskStateStats((JobVertexID)e.getKey(), (Integer)e.getValue()))));
    }

    PendingCheckpointStats(long checkpointId, long triggerTimestamp, CheckpointProperties props, int totalSubtaskCount, Map<JobVertexID, TaskStateStats> taskStats) {
        this(checkpointId, triggerTimestamp, props, totalSubtaskCount, 0, taskStats, 0L, 0L, 0L, 0L, false, null);
    }

    PendingCheckpointStats(long checkpointId, long triggerTimestamp, CheckpointProperties props, int totalSubtaskCount, int acknowledgedSubtaskCount, Map<JobVertexID, TaskStateStats> taskStats, long currentCheckpointedSize, long currentStateSize, long processedData, long persistedData, boolean unalignedCheckpoint, @Nullable SubtaskStateStats latestAcknowledgedSubtask) {
        super(checkpointId, triggerTimestamp, props, totalSubtaskCount, taskStats);
        this.currentCheckpointedSize = currentCheckpointedSize;
        this.currentStateSize = currentStateSize;
        this.currentProcessedData = processedData;
        this.currentPersistedData = persistedData;
        this.unalignedCheckpoint = unalignedCheckpoint;
        this.latestAcknowledgedSubtask = latestAcknowledgedSubtask;
        this.currentNumAcknowledgedSubtasks = acknowledgedSubtaskCount;
    }

    @Override
    public CheckpointStatsStatus getStatus() {
        return CheckpointStatsStatus.IN_PROGRESS;
    }

    @Override
    public int getNumberOfAcknowledgedSubtasks() {
        return this.currentNumAcknowledgedSubtasks;
    }

    @Override
    public long getStateSize() {
        return this.currentStateSize;
    }

    @Override
    public long getMetadataSize() {
        return -1L;
    }

    @Override
    public long getCheckpointedSize() {
        return this.currentCheckpointedSize;
    }

    @Override
    public long getProcessedData() {
        return this.currentProcessedData;
    }

    @Override
    public long getPersistedData() {
        return this.currentPersistedData;
    }

    @Override
    public boolean isUnalignedCheckpoint() {
        return this.unalignedCheckpoint;
    }

    @Override
    public SubtaskStateStats getLatestAcknowledgedSubtaskStats() {
        return this.latestAcknowledgedSubtask;
    }

    boolean reportSubtaskStats(JobVertexID jobVertexId, SubtaskStateStats subtask) {
        TaskStateStats taskStateStats = (TaskStateStats)this.taskStats.get(jobVertexId);
        if (taskStateStats != null && taskStateStats.reportSubtaskStats(subtask)) {
            long persistedData;
            if (subtask.isCompleted()) {
                ++this.currentNumAcknowledgedSubtasks;
                this.latestAcknowledgedSubtask = subtask;
            }
            this.currentCheckpointedSize += subtask.getCheckpointedSize();
            this.currentStateSize += subtask.getStateSize();
            long processedData = subtask.getProcessedData();
            if (processedData > 0L) {
                this.currentProcessedData += processedData;
            }
            if ((persistedData = subtask.getPersistedData()) > 0L) {
                this.currentPersistedData += persistedData;
            }
            this.unalignedCheckpoint |= subtask.getUnalignedCheckpoint();
            return true;
        }
        return false;
    }

    CompletedCheckpointStats toCompletedCheckpointStats(String externalPointer, long metadataSize) {
        return new CompletedCheckpointStats(this.checkpointId, this.triggerTimestamp, this.props, this.numberOfSubtasks, new HashMap<JobVertexID, TaskStateStats>(this.taskStats), this.currentNumAcknowledgedSubtasks, this.currentCheckpointedSize, this.currentStateSize, metadataSize, this.currentProcessedData, this.currentPersistedData, this.unalignedCheckpoint, this.latestAcknowledgedSubtask, externalPointer);
    }

    FailedCheckpointStats toFailedCheckpoint(long failureTimestamp, @Nullable Throwable cause) {
        return new FailedCheckpointStats(this.checkpointId, this.triggerTimestamp, this.props, this.numberOfSubtasks, new HashMap<JobVertexID, TaskStateStats>(this.taskStats), this.currentNumAcknowledgedSubtasks, this.currentCheckpointedSize, this.currentStateSize, this.currentProcessedData, this.currentPersistedData, this.unalignedCheckpoint, failureTimestamp, this.latestAcknowledgedSubtask, cause);
    }

    public String toString() {
        return "PendingCheckpoint(id=" + this.getCheckpointId() + ")";
    }
}

