/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.metadata;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.runtime.checkpoint.metadata.ChannelStateHandleSerializer;
import org.apache.flink.runtime.checkpoint.metadata.ChannelStateHandleSerializerV1;
import org.apache.flink.runtime.checkpoint.metadata.MetadataV2V3SerializerBase;
import org.apache.flink.runtime.state.AbstractChannelStateHandle;
import org.apache.flink.runtime.state.AbstractMergedChannelStateHandle;
import org.apache.flink.runtime.state.ChannelStateHelper;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.InputStateHandle;
import org.apache.flink.runtime.state.MergedInputChannelStateHandle;
import org.apache.flink.runtime.state.MergedResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.OutputStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;

class ChannelStateHandleSerializerV2
implements ChannelStateHandleSerializer {
    private static final byte INPUT_CHANNEL_STATE_HANDLE = 1;
    private static final byte RESULT_SUBPARTITION_STATE_HANDLE = 2;
    private static final byte MERGED_INPUT_CHANNEL_STATE_HANDLE = 3;
    private static final byte MERGED_RESULT_SUBPARTITION_STATE_HANDLE = 4;

    ChannelStateHandleSerializerV2() {
    }

    @Override
    public void serialize(OutputStateHandle handle, DataOutputStream dos) throws IOException {
        if (handle instanceof ResultSubpartitionStateHandle) {
            dos.writeByte(2);
            ChannelStateHandleSerializerV1.serializeChannelStateHandle((ResultSubpartitionStateHandle)handle, dos, ChannelStateHelper.RESULT_SUBPARTITION_INFO_WRITER);
        } else if (handle instanceof MergedResultSubpartitionStateHandle) {
            dos.writeByte(4);
            this.serializeMergedChannelStateHandle((AbstractMergedChannelStateHandle)((Object)handle), dos);
        } else {
            throw new IllegalStateException("Unsupported input state handle.");
        }
    }

    @Override
    public OutputStateHandle deserializeOutputStateHandle(DataInputStream dis, MetadataV2V3SerializerBase.DeserializationContext context) throws IOException {
        int type = dis.read();
        if (2 == type) {
            return (OutputStateHandle)ChannelStateHandleSerializerV1.deserializeChannelStateHandle(ChannelStateHelper.RESULT_SUBPARTITION_INFO_READER, ResultSubpartitionStateHandle::new, dis, context);
        }
        if (4 == type) {
            Tuple4<Integer, StreamStateHandle, Long, byte[]> t4 = this.deserializeMergedChannelStateHandle(dis, context);
            return new MergedResultSubpartitionStateHandle((Integer)t4.f0, (StreamStateHandle)t4.f1, (Long)t4.f2, (byte[])t4.f3);
        }
        throw new IllegalStateException("Unknown output state handle type.");
    }

    @Override
    public void serialize(InputStateHandle handle, DataOutputStream dos) throws IOException {
        if (handle instanceof InputChannelStateHandle) {
            dos.writeByte(1);
            ChannelStateHandleSerializerV1.serializeChannelStateHandle((InputChannelStateHandle)handle, dos, ChannelStateHelper.INPUT_CHANNEL_INFO_WRITER);
        } else if (handle instanceof MergedInputChannelStateHandle) {
            dos.writeByte(3);
            this.serializeMergedChannelStateHandle((AbstractMergedChannelStateHandle)((Object)handle), dos);
        } else {
            throw new IllegalStateException("Unsupported output state handle.");
        }
    }

    @Override
    public InputStateHandle deserializeInputStateHandle(DataInputStream dis, MetadataV2V3SerializerBase.DeserializationContext context) throws IOException {
        int type = dis.read();
        if (1 == type) {
            return (InputStateHandle)ChannelStateHandleSerializerV1.deserializeChannelStateHandle(ChannelStateHelper.INPUT_CHANNEL_INFO_READER, InputChannelStateHandle::new, dis, context);
        }
        if (3 == type) {
            Tuple4<Integer, StreamStateHandle, Long, byte[]> t4 = this.deserializeMergedChannelStateHandle(dis, context);
            return new MergedInputChannelStateHandle((Integer)t4.f0, (StreamStateHandle)t4.f1, (Long)t4.f2, (byte[])t4.f3);
        }
        throw new IllegalStateException("Unknown input state handle type.");
    }

    private <Info> void serializeMergedChannelStateHandle(AbstractMergedChannelStateHandle<Info, AbstractChannelStateHandle<Info>> handle, DataOutputStream dos) throws IOException {
        dos.writeInt(handle.getSubtaskIndex());
        dos.writeLong(handle.getStateSize());
        MetadataV2V3SerializerBase.serializeStreamStateHandle(handle.getDelegate(), dos);
        dos.writeInt(handle.getSerializedChannelOffsets().length);
        dos.write(handle.getSerializedChannelOffsets());
    }

    private Tuple4<Integer, StreamStateHandle, Long, byte[]> deserializeMergedChannelStateHandle(DataInputStream dis, MetadataV2V3SerializerBase.DeserializationContext context) throws IOException {
        int subtaskIndex = dis.readInt();
        long stateSize = dis.readLong();
        StreamStateHandle delegateHandle = MetadataV2V3SerializerBase.deserializeStreamStateHandle(dis, context);
        int serializedChannelOffsetsLength = dis.readInt();
        byte[] serializedChannelOffsets = new byte[serializedChannelOffsetsLength];
        dis.readFully(serializedChannelOffsets);
        return Tuple4.of((Object)subtaskIndex, (Object)delegateHandle, (Object)stateSize, (Object)serializedChannelOffsets);
    }
}

