/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.PendingRequest;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

final class ResourceRequestPreMappings {
    private final boolean matchingFulfilled;
    private final Map<ResourceProfile, Map<ResourceProfile, Integer>> baseRequiredResourcePreMappings;
    private final Map<ResourceProfile, Integer> remainingFlexibleResources;

    private ResourceRequestPreMappings(boolean matchingFulfilled, Map<ResourceProfile, Map<ResourceProfile, Integer>> baseRequiredResourcePreMappings, Map<ResourceProfile, Integer> remainingFlexibleResources) {
        this.matchingFulfilled = matchingFulfilled;
        this.baseRequiredResourcePreMappings = CollectionUtil.newHashMapWithExpectedSize((int)baseRequiredResourcePreMappings.size());
        this.baseRequiredResourcePreMappings.putAll(baseRequiredResourcePreMappings);
        this.remainingFlexibleResources = CollectionUtil.newHashMapWithExpectedSize((int)remainingFlexibleResources.size());
        this.remainingFlexibleResources.putAll(remainingFlexibleResources);
    }

    static ResourceRequestPreMappings createFrom(Collection<PendingRequest> pendingRequests, Collection<? extends PhysicalSlot> slots) {
        return new ResourceRequestPreMappingsBuilder(pendingRequests, slots).build();
    }

    boolean isMatchingFulfilled() {
        return this.matchingFulfilled;
    }

    boolean hasAvailableProfile(ResourceProfile requiredResourceProfile, ResourceProfile acquirableResourceProfile) {
        Map basePreMapping = this.baseRequiredResourcePreMappings.getOrDefault(requiredResourceProfile, new HashMap());
        Integer remainingCnt = basePreMapping.getOrDefault(acquirableResourceProfile, 0);
        if (remainingCnt > 0) {
            return true;
        }
        return this.remainingFlexibleResources.getOrDefault(acquirableResourceProfile, 0) > 0;
    }

    void decrease(ResourceProfile requiredResourceProfile, ResourceProfile acquiredResourceProfile) {
        Map basePreMapping = this.baseRequiredResourcePreMappings.getOrDefault(requiredResourceProfile, new HashMap());
        Integer remainingCntOfBaseMappings = basePreMapping.getOrDefault(acquiredResourceProfile, 0);
        Integer remainingCntOfFlexibleResources = this.remainingFlexibleResources.getOrDefault(acquiredResourceProfile, 0);
        Preconditions.checkState((remainingCntOfBaseMappings > 0 || remainingCntOfFlexibleResources > 0 ? 1 : 0) != 0, (String)"Remaining acquired resource profile %s to match %s is not enough.", (Object[])new Object[]{acquiredResourceProfile, requiredResourceProfile});
        if (remainingCntOfBaseMappings > 0) {
            basePreMapping.put(acquiredResourceProfile, remainingCntOfBaseMappings - 1);
            return;
        }
        if (remainingCntOfFlexibleResources > 0) {
            this.remainingFlexibleResources.put(acquiredResourceProfile, remainingCntOfFlexibleResources - 1);
            this.adjustBaseToRemainingFlexibleResources(basePreMapping);
        }
    }

    private void adjustBaseToRemainingFlexibleResources(Map<ResourceProfile, Integer> basePreMapping) {
        Optional<Map.Entry> releasableOptOfBaseMappings = basePreMapping.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).findFirst();
        Preconditions.checkState((boolean)releasableOptOfBaseMappings.isPresent(), (Object)"No releasable mapping found in the base mappings between resources and requests.");
        Map.Entry releasable = releasableOptOfBaseMappings.get();
        ResourceProfile releasableResourceProfile = (ResourceProfile)releasable.getKey();
        basePreMapping.put(releasableResourceProfile, (Integer)releasable.getValue() - 1);
        this.remainingFlexibleResources.compute(releasableResourceProfile, (resourceProfile, oldValue) -> oldValue == null ? 1 : oldValue + 1);
    }

    @VisibleForTesting
    static ResourceRequestPreMappings createFrom(boolean allMatchable, Map<ResourceProfile, Map<ResourceProfile, Integer>> baseRequiredResourcePreMappings, Map<ResourceProfile, Integer> remainingFlexibleResources) {
        return new ResourceRequestPreMappings(allMatchable, baseRequiredResourcePreMappings, remainingFlexibleResources);
    }

    @VisibleForTesting
    Map<ResourceProfile, Map<ResourceProfile, Integer>> getBaseRequiredResourcePreMappings() {
        return Collections.unmodifiableMap(this.baseRequiredResourcePreMappings);
    }

    @VisibleForTesting
    int getAvailableResourceCntOfBasePreMappings(ResourceProfile requiredResourceProfile, ResourceProfile acquirableResourceProfile) {
        return ((Map)this.baseRequiredResourcePreMappings.getOrDefault(requiredResourceProfile, new HashMap())).getOrDefault(acquirableResourceProfile, 0);
    }

    @VisibleForTesting
    Map<ResourceProfile, Integer> getRemainingFlexibleResources() {
        return Collections.unmodifiableMap(this.remainingFlexibleResources);
    }

    @VisibleForTesting
    int getAvailableResourceCntOfRemainingFlexibleMapping(ResourceProfile availableResourceProfile) {
        return this.remainingFlexibleResources.getOrDefault(availableResourceProfile, 0);
    }

    private static final class ResourceRequestPreMappingsBuilder {
        private final Map<ResourceProfile, Integer> unfulfilledRequired;
        private final Map<ResourceProfile, Integer> availableResources;
        private final Map<ResourceProfile, Map<ResourceProfile, Integer>> baseRequiredResourcePreMappings;

        private ResourceRequestPreMappingsBuilder(Collection<PendingRequest> pendingRequests, Collection<? extends PhysicalSlot> slots) {
            this.unfulfilledRequired = pendingRequests.stream().collect(Collectors.groupingBy(PendingRequest::getResourceProfile, Collectors.summingInt(ignored -> 1)));
            this.unfulfilledRequired.keySet().forEach(rp -> Preconditions.checkState((!rp.equals(ResourceProfile.ZERO) && !rp.equals(ResourceProfile.ANY) ? 1 : 0) != 0, (Object)"The required resource must not be ResourceProfile.ZERO and ResourceProfile.ANY."));
            this.availableResources = slots.stream().collect(Collectors.groupingBy(SlotInfo::getResourceProfile, Collectors.summingInt(ignored -> 1)));
            this.availableResources.keySet().forEach(rp -> Preconditions.checkState((!rp.equals(ResourceProfile.UNKNOWN) && !rp.equals(ResourceProfile.ZERO) ? 1 : 0) != 0, (Object)"The resource profile of a slot must not be ResourceProfile.UNKNOWN and ResourceProfile.ZERO."));
            this.baseRequiredResourcePreMappings = CollectionUtil.newHashMapWithExpectedSize((int)slots.size());
        }

        private ResourceRequestPreMappings build() {
            if (this.unfulfilledRequired.isEmpty() || this.availableResources.isEmpty() || !this.canFulfillDesiredResources()) {
                return this.currentPreMappings(false);
            }
            this.buildFineGrainedRequestFulfilledExactMapping();
            if (this.isMatchingFulfilled()) {
                return this.currentPreMappings(true);
            }
            this.buildRemainingFineGrainedRequestFulfilledAnyMapping();
            if (this.isMatchingFulfilled()) {
                return this.currentPreMappings(true);
            }
            this.buildUnknownRequestFulfilledMapping();
            return this.currentPreMappings(this.isMatchingFulfilled());
        }

        private void buildFineGrainedRequestFulfilledExactMapping() {
            for (Map.Entry<ResourceProfile, Integer> unfulfilledEntry : new HashMap<ResourceProfile, Integer>(this.unfulfilledRequired).entrySet()) {
                ResourceProfile requiredFineGrainedResourceProfile = unfulfilledEntry.getKey();
                if (ResourceProfile.UNKNOWN.equals(requiredFineGrainedResourceProfile)) continue;
                int unfulfilledFineGrainedRequiredCnt = unfulfilledEntry.getValue();
                int availableFineGrainedResourceCnt = this.availableResources.getOrDefault(requiredFineGrainedResourceProfile, 0);
                if (unfulfilledFineGrainedRequiredCnt <= 0 || availableFineGrainedResourceCnt <= 0) continue;
                int diff = unfulfilledFineGrainedRequiredCnt - availableFineGrainedResourceCnt;
                Map fulfilledProfileCount = this.baseRequiredResourcePreMappings.computeIfAbsent(requiredFineGrainedResourceProfile, ignored -> new HashMap());
                fulfilledProfileCount.put(requiredFineGrainedResourceProfile, diff > 0 ? availableFineGrainedResourceCnt : unfulfilledFineGrainedRequiredCnt);
                int newUnfulfilledFineGrainedRequiredCnt = Math.max(diff, 0);
                int unAvailableFineGrainedResourceCnt = Math.max(-diff, 0);
                this.availableResources.put(requiredFineGrainedResourceProfile, unAvailableFineGrainedResourceCnt);
                this.unfulfilledRequired.put(requiredFineGrainedResourceProfile, newUnfulfilledFineGrainedRequiredCnt);
            }
        }

        private void buildRemainingFineGrainedRequestFulfilledAnyMapping() {
            Integer availableResourceProfileANYCount = this.availableResources.getOrDefault(ResourceProfile.ANY, 0);
            if (availableResourceProfileANYCount <= 0) {
                return;
            }
            for (Map.Entry<ResourceProfile, Integer> unfulfilledEntry : new HashMap<ResourceProfile, Integer>(this.unfulfilledRequired).entrySet()) {
                int unfulfilledFineGrainedRequiredCnt;
                availableResourceProfileANYCount = this.availableResources.getOrDefault(ResourceProfile.ANY, 0);
                if (availableResourceProfileANYCount <= 0) {
                    return;
                }
                ResourceProfile fineGrainedRequestResourceProfile = unfulfilledEntry.getKey();
                if (ResourceProfile.UNKNOWN.equals(fineGrainedRequestResourceProfile) || (unfulfilledFineGrainedRequiredCnt = this.unfulfilledRequired.getOrDefault(fineGrainedRequestResourceProfile, 0).intValue()) <= 0) continue;
                int diff = unfulfilledFineGrainedRequiredCnt - availableResourceProfileANYCount;
                Map fulfilledProfileCount = this.baseRequiredResourcePreMappings.computeIfAbsent(fineGrainedRequestResourceProfile, ignored -> new HashMap());
                fulfilledProfileCount.put(ResourceProfile.ANY, diff > 0 ? availableResourceProfileANYCount : unfulfilledFineGrainedRequiredCnt);
                int newUnfulfilledFineGrainedRequiredCnt = Math.max(diff, 0);
                int newAvailableResourceProfileANYCount = Math.max(-diff, 0);
                this.availableResources.put(ResourceProfile.ANY, newAvailableResourceProfileANYCount);
                this.unfulfilledRequired.put(fineGrainedRequestResourceProfile, newUnfulfilledFineGrainedRequiredCnt);
            }
        }

        private void buildUnknownRequestFulfilledMapping() {
            if (this.unfulfilledRequired.getOrDefault(ResourceProfile.UNKNOWN, 0) <= 0) {
                return;
            }
            for (Map.Entry<ResourceProfile, Integer> availableResourceEntry : new HashMap<ResourceProfile, Integer>(this.availableResources).entrySet()) {
                Integer unfulfilledUnknownRequiredCnt = this.unfulfilledRequired.getOrDefault(ResourceProfile.UNKNOWN, 0);
                ResourceProfile availableResourceProfile = availableResourceEntry.getKey();
                int availableResourceCnt = this.availableResources.getOrDefault(availableResourceProfile, 0);
                if (availableResourceCnt <= 0) continue;
                if (unfulfilledUnknownRequiredCnt <= 0) {
                    return;
                }
                int diff = unfulfilledUnknownRequiredCnt - availableResourceCnt;
                Map fulfilledProfileCount = this.baseRequiredResourcePreMappings.computeIfAbsent(ResourceProfile.UNKNOWN, ignored -> new HashMap());
                fulfilledProfileCount.put(availableResourceProfile, diff > 0 ? availableResourceCnt : unfulfilledUnknownRequiredCnt);
                int newUnfulfilledUnknownRequiredCnt = Math.max(diff, 0);
                int newAvailableResourceCnt = Math.max(-diff, 0);
                this.availableResources.put(availableResourceProfile, newAvailableResourceCnt);
                this.unfulfilledRequired.put(ResourceProfile.UNKNOWN, newUnfulfilledUnknownRequiredCnt);
            }
        }

        private ResourceRequestPreMappings currentPreMappings(boolean matchingFulfilled) {
            if (!matchingFulfilled) {
                return new ResourceRequestPreMappings(false, new HashMap<ResourceProfile, Map<ResourceProfile, Integer>>(), new HashMap<ResourceProfile, Integer>());
            }
            return new ResourceRequestPreMappings(true, Collections.unmodifiableMap(this.baseRequiredResourcePreMappings), Collections.unmodifiableMap(this.availableResources));
        }

        private boolean isMatchingFulfilled() {
            for (ResourceProfile unfulfilledProfile : this.unfulfilledRequired.keySet()) {
                Integer unfulfilled = this.unfulfilledRequired.getOrDefault(unfulfilledProfile, 0);
                if (unfulfilled <= 0) continue;
                return false;
            }
            return true;
        }

        private boolean canFulfillDesiredResources() {
            Integer totalUnfulfilledCnt = this.unfulfilledRequired.values().stream().reduce(0, Integer::sum);
            Integer totalAvailableCnt = this.availableResources.values().stream().reduce(0, Integer::sum);
            return totalAvailableCnt >= totalUnfulfilledCnt;
        }
    }
}

