/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.checkpoints;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointStatsHistory;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.NotFoundException;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.checkpoints.AbstractCheckpointHandler;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointStatsCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobVertexIdPathParameter;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.SubtaskCheckpointStatistics;
import org.apache.flink.runtime.rest.messages.checkpoints.TaskCheckpointMessageParameters;
import org.apache.flink.runtime.rest.messages.checkpoints.TaskCheckpointStatisticsWithSubtaskDetails;
import org.apache.flink.runtime.rest.messages.util.stats.StatsSummaryDto;
import org.apache.flink.runtime.util.stats.StatsSummary;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.OnlyExecutionGraphJsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.guava33.com.google.common.cache.Cache;

public class TaskCheckpointStatisticDetailsHandler
extends AbstractCheckpointHandler<TaskCheckpointStatisticsWithSubtaskDetails, TaskCheckpointMessageParameters>
implements OnlyExecutionGraphJsonArchivist {
    public TaskCheckpointStatisticDetailsHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, TaskCheckpointStatisticsWithSubtaskDetails, TaskCheckpointMessageParameters> messageHeaders, Executor executor, Cache<JobID, CompletableFuture<CheckpointStatsSnapshot>> checkpointStatsSnapshotCache, CheckpointStatsCache checkpointStatsCache) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, executor, checkpointStatsSnapshotCache, checkpointStatsCache);
    }

    @Override
    protected TaskCheckpointStatisticsWithSubtaskDetails handleCheckpointRequest(HandlerRequest<EmptyRequestBody> request, AbstractCheckpointStats checkpointStats) throws RestHandlerException {
        JobVertexID jobVertexId = (JobVertexID)request.getPathParameter(JobVertexIdPathParameter.class);
        TaskStateStats taskStatistics = checkpointStats.getTaskStateStats(jobVertexId);
        if (taskStatistics == null) {
            throw new NotFoundException("There is no checkpoint statistics for task " + String.valueOf(jobVertexId) + ".");
        }
        return TaskCheckpointStatisticDetailsHandler.createCheckpointDetails(checkpointStats, taskStatistics);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
        CheckpointStatsSnapshot stats = graph.getCheckpointStatsSnapshot();
        if (stats == null) {
            return Collections.emptyList();
        }
        CheckpointStatsHistory history = stats.getHistory();
        ArrayList<ArchivedJson> archive = new ArrayList<ArchivedJson>(history.getCheckpoints().size());
        for (AbstractCheckpointStats checkpoint : history.getCheckpoints()) {
            for (TaskStateStats subtaskStats : checkpoint.getAllTaskStateStats()) {
                TaskCheckpointStatisticsWithSubtaskDetails json = TaskCheckpointStatisticDetailsHandler.createCheckpointDetails(checkpoint, subtaskStats);
                String path = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", graph.getJobID().toString()).replace(":checkpointid", String.valueOf(checkpoint.getCheckpointId())).replace(":vertexid", subtaskStats.getJobVertexId().toString());
                archive.add(new ArchivedJson(path, json));
            }
        }
        return archive;
    }

    private static TaskCheckpointStatisticsWithSubtaskDetails createCheckpointDetails(AbstractCheckpointStats checkpointStats, TaskStateStats taskStatistics) {
        TaskCheckpointStatisticsWithSubtaskDetails.Summary summary = TaskCheckpointStatisticDetailsHandler.createSummary(taskStatistics.getSummaryStats(), checkpointStats.getTriggerTimestamp());
        List<SubtaskCheckpointStatistics> subtaskCheckpointStatistics = TaskCheckpointStatisticDetailsHandler.createSubtaskCheckpointStatistics(taskStatistics.getSubtaskStats(), checkpointStats.getTriggerTimestamp());
        return new TaskCheckpointStatisticsWithSubtaskDetails(checkpointStats.getCheckpointId(), checkpointStats.getStatus(), taskStatistics.getLatestAckTimestamp(), taskStatistics.getCheckpointedSize(), taskStatistics.getStateSize(), taskStatistics.getEndToEndDuration(checkpointStats.getTriggerTimestamp()), 0L, taskStatistics.getProcessedDataStats(), taskStatistics.getPersistedDataStats(), taskStatistics.getNumberOfSubtasks(), taskStatistics.getNumberOfAcknowledgedSubtasks(), summary, subtaskCheckpointStatistics);
    }

    private static TaskCheckpointStatisticsWithSubtaskDetails.Summary createSummary(TaskStateStats.TaskStateStatsSummary taskStatisticsSummary, long triggerTimestamp) {
        StatsSummary ackTSStats = taskStatisticsSummary.getAckTimestampStats();
        TaskCheckpointStatisticsWithSubtaskDetails.CheckpointDuration checkpointDuration = new TaskCheckpointStatisticsWithSubtaskDetails.CheckpointDuration(StatsSummaryDto.valueOf(taskStatisticsSummary.getSyncCheckpointDurationStats()), StatsSummaryDto.valueOf(taskStatisticsSummary.getAsyncCheckpointDurationStats()));
        TaskCheckpointStatisticsWithSubtaskDetails.CheckpointAlignment checkpointAlignment = new TaskCheckpointStatisticsWithSubtaskDetails.CheckpointAlignment(new StatsSummaryDto(0L, 0L, 0L, 0.0, 0.0, 0.0, 0.0, 0.0), StatsSummaryDto.valueOf(taskStatisticsSummary.getProcessedDataStats()), StatsSummaryDto.valueOf(taskStatisticsSummary.getPersistedDataStats()), StatsSummaryDto.valueOf(taskStatisticsSummary.getAlignmentDurationStats()));
        return new TaskCheckpointStatisticsWithSubtaskDetails.Summary(StatsSummaryDto.valueOf(taskStatisticsSummary.getCheckpointedSize()), StatsSummaryDto.valueOf(taskStatisticsSummary.getStateSizeStats()), new StatsSummaryDto(Math.max(0L, ackTSStats.getMinimum() - triggerTimestamp), Math.max(0L, ackTSStats.getMaximum() - triggerTimestamp), Math.max(0L, ackTSStats.getAverage() - triggerTimestamp), ackTSStats.createSnapshot().getQuantile(0.5), ackTSStats.createSnapshot().getQuantile(0.9), ackTSStats.createSnapshot().getQuantile(0.95), ackTSStats.createSnapshot().getQuantile(0.99), ackTSStats.createSnapshot().getQuantile(0.999)), checkpointDuration, checkpointAlignment, StatsSummaryDto.valueOf(taskStatisticsSummary.getCheckpointStartDelayStats()));
    }

    private static List<SubtaskCheckpointStatistics> createSubtaskCheckpointStatistics(SubtaskStateStats[] subtaskStateStats, long triggerTimestamp) {
        ArrayList<SubtaskCheckpointStatistics> result = new ArrayList<SubtaskCheckpointStatistics>(subtaskStateStats.length);
        for (int i = 0; i < subtaskStateStats.length; ++i) {
            SubtaskStateStats subtask = subtaskStateStats[i];
            if (subtask == null) {
                result.add(new SubtaskCheckpointStatistics.PendingSubtaskCheckpointStatistics(i));
                continue;
            }
            result.add(new SubtaskCheckpointStatistics.CompletedSubtaskCheckpointStatistics(i, subtask.getAckTimestamp(), subtask.getEndToEndDuration(triggerTimestamp), subtask.getCheckpointedSize(), subtask.getStateSize(), new SubtaskCheckpointStatistics.CompletedSubtaskCheckpointStatistics.CheckpointDuration(subtask.getSyncCheckpointDuration(), subtask.getAsyncCheckpointDuration()), new SubtaskCheckpointStatistics.CompletedSubtaskCheckpointStatistics.CheckpointAlignment(0L, subtask.getProcessedData(), subtask.getPersistedData(), subtask.getAlignmentDuration()), subtask.getCheckpointStartDelay(), subtask.getUnalignedCheckpoint(), !subtask.isCompleted()));
        }
        return result;
    }
}

