/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.loading;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.scheduler.loading.LoadingWeight;

@Internal
public interface WeightLoadable {
    @Nonnull
    public LoadingWeight getLoading();

    public static <T extends WeightLoadable> List<T> sortByLoadingDescend(Collection<T> weightLoadables) {
        return weightLoadables.stream().sorted((leftReq, rightReq) -> rightReq.getLoading().compareTo(leftReq.getLoading())).collect(Collectors.toList());
    }
}

