/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.metrics;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.events.Events;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.scheduler.metrics.ExecutionStatusMetricsRegistrar;
import org.apache.flink.runtime.scheduler.metrics.StateTimeMetric;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class AllSubTasksRunningOrFinishedStateTimeMetrics
implements ExecutionStatusMetricsRegistrar,
StateTimeMetric {
    public static final String STATUS_ATTRIBUTE = "status";
    private static final long NOT_STARTED = -1L;
    private final MetricOptions.JobStatusMetricsSettings stateTimeMetricsSettings;
    private final Clock clock;
    private final Set<ExecutionAttemptID> expectedRunningVertices = new HashSet<ExecutionAttemptID>();
    private int numRunningVertices = 0;
    private long currentAllRunningOrFinishedStartTime = -1L;
    private long allRunningOrFinishedAccumulatedTime = 0L;
    @Nullable
    private MetricGroup registeredMetricGroup;

    public AllSubTasksRunningOrFinishedStateTimeMetrics(JobType semantic, MetricOptions.JobStatusMetricsSettings stateTimeMetricsSettings) {
        this(semantic, stateTimeMetricsSettings, (Clock)SystemClock.getInstance());
    }

    @VisibleForTesting
    AllSubTasksRunningOrFinishedStateTimeMetrics(JobType jobType, MetricOptions.JobStatusMetricsSettings stateTimeMetricsSettings, Clock clock) {
        Preconditions.checkState((jobType == JobType.STREAMING ? 1 : 0) != 0, (Object)"This metric should only be created and registered for streaming jobs!");
        this.stateTimeMetricsSettings = stateTimeMetricsSettings;
        this.clock = clock;
        this.registeredMetricGroup = null;
    }

    @Override
    public long getCurrentTime() {
        return this.currentAllRunningOrFinishedStartTime == -1L ? 0L : Math.max(0L, this.clock.absoluteTimeMillis() - this.currentAllRunningOrFinishedStartTime);
    }

    @Override
    public long getTotalTime() {
        return this.getCurrentTime() + this.allRunningOrFinishedAccumulatedTime;
    }

    @Override
    public long getBinary() {
        return this.currentAllRunningOrFinishedStartTime == -1L ? 0L : 1L;
    }

    @Override
    public void registerMetrics(MetricGroup metricGroup) {
        StateTimeMetric.register(this.stateTimeMetricsSettings, metricGroup, this, "allSubTasksRunningOrFinished");
        this.registeredMetricGroup = metricGroup;
    }

    public void onStateUpdate(Execution execution, ExecutionState previousState, ExecutionState newState) {
        this.onStateUpdate(execution.getAttemptId(), previousState, newState);
    }

    @Override
    public void onStateUpdate(ExecutionAttemptID execution, ExecutionState previousState, ExecutionState newState) {
        switch (newState) {
            case SCHEDULED: {
                this.expectedRunningVertices.add(execution);
                break;
            }
            case DEPLOYING: 
            case INITIALIZING: {
                break;
            }
            case RUNNING: {
                ++this.numRunningVertices;
                if (this.allVerticesWereRunningOrFinished() || this.expectedRunningVertices.size() != this.numRunningVertices) break;
                this.markAllRequiredVerticesRunning();
                break;
            }
            case FINISHED: {
                this.expectedRunningVertices.remove(execution);
                break;
            }
            default: {
                if (this.allVerticesWereRunningOrFinished()) {
                    this.markAnyVertexNotRunningOrRunningOrFinished();
                }
                this.expectedRunningVertices.remove(execution);
            }
        }
        switch (previousState) {
            case RUNNING: {
                --this.numRunningVertices;
            }
        }
    }

    private boolean allVerticesWereRunningOrFinished() {
        return this.currentAllRunningOrFinishedStartTime != -1L;
    }

    private void markAllRequiredVerticesRunning() {
        this.currentAllRunningOrFinishedStartTime = this.clock.absoluteTimeMillis();
        this.reportAllSubtaskStatusChangeEvent(true);
    }

    private void markAnyVertexNotRunningOrRunningOrFinished() {
        this.allRunningOrFinishedAccumulatedTime = Math.max(0L, this.clock.absoluteTimeMillis() - this.currentAllRunningOrFinishedStartTime);
        this.currentAllRunningOrFinishedStartTime = -1L;
        this.reportAllSubtaskStatusChangeEvent(false);
    }

    private void reportAllSubtaskStatusChangeEvent(boolean allRunningOrFinished) {
        MetricGroup metricGroup = this.registeredMetricGroup;
        if (metricGroup != null) {
            metricGroup.addEvent(Events.AllSubtasksStatusChangeEvent.builder(AllSubTasksRunningOrFinishedStateTimeMetrics.class).setSeverity("INFO").setObservedTsMillis(this.clock.absoluteTimeMillis()).setAttribute(STATUS_ATTRIBUTE, allRunningOrFinished ? Status.ALL_RUNNING_OR_FINISHED.toString() : Status.NOT_ALL_RUNNING_OR_FINISHED.toString()));
        }
    }

    public static enum Status {
        ALL_RUNNING_OR_FINISHED,
        NOT_ALL_RUNNING_OR_FINISHED;

    }
}

