/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.InternalKeyContext;
import org.apache.flink.runtime.state.KeyExtractorFunction;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupedInternalPriorityQueue;
import org.apache.flink.runtime.state.PriorityComparable;
import org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.RegisteredPriorityQueueStateBackendMetaInfo;
import org.apache.flink.runtime.state.StateSerializerProvider;
import org.apache.flink.runtime.state.StateSnapshotRestore;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueElement;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueSetFactory;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueSnapshotRestoreWrapper;
import org.apache.flink.runtime.state.heap.StateTable;
import org.apache.flink.runtime.state.heap.StateTableFactory;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;

class HeapMetaInfoRestoreOperation<K> {
    private final StateSerializerProvider<K> keySerializerProvider;
    private final HeapPriorityQueueSetFactory priorityQueueSetFactory;
    @Nonnull
    private final KeyGroupRange keyGroupRange;
    @Nonnegative
    private final int numberOfKeyGroups;
    private final StateTableFactory<K> stateTableFactory;
    private final InternalKeyContext<K> keyContext;

    HeapMetaInfoRestoreOperation(StateSerializerProvider<K> keySerializerProvider, HeapPriorityQueueSetFactory priorityQueueSetFactory, @Nonnull KeyGroupRange keyGroupRange, int numberOfKeyGroups, StateTableFactory<K> stateTableFactory, InternalKeyContext<K> keyContext) {
        this.keySerializerProvider = keySerializerProvider;
        this.priorityQueueSetFactory = priorityQueueSetFactory;
        this.keyGroupRange = keyGroupRange;
        this.numberOfKeyGroups = numberOfKeyGroups;
        this.stateTableFactory = stateTableFactory;
        this.keyContext = keyContext;
    }

    Map<Integer, StateMetaInfoSnapshot> createOrCheckStateForMetaInfo(List<StateMetaInfoSnapshot> restoredMetaInfo, Map<String, StateTable<K, ?, ?>> registeredKVStates, Map<String, HeapPriorityQueueSnapshotRestoreWrapper<?>> registeredPQStates) {
        HashMap<Integer, StateMetaInfoSnapshot> kvStatesById = new HashMap<Integer, StateMetaInfoSnapshot>();
        for (StateMetaInfoSnapshot metaInfoSnapshot : restoredMetaInfo) {
            switch (metaInfoSnapshot.getBackendStateType()) {
                case KEY_VALUE: {
                    StateSnapshotRestore registeredState = registeredKVStates.get(metaInfoSnapshot.getName());
                    if (registeredState != null) break;
                    RegisteredKeyValueStateBackendMetaInfo registeredKeyedBackendStateMetaInfo = new RegisteredKeyValueStateBackendMetaInfo(metaInfoSnapshot);
                    registeredKVStates.put(metaInfoSnapshot.getName(), this.stateTableFactory.newStateTable(this.keyContext, registeredKeyedBackendStateMetaInfo, this.keySerializerProvider.currentSchemaSerializer()));
                    break;
                }
                case PRIORITY_QUEUE: {
                    StateSnapshotRestore registeredState = registeredPQStates.get(metaInfoSnapshot.getName());
                    if (registeredState != null) break;
                    registeredPQStates.put(metaInfoSnapshot.getName(), this.createInternal(new RegisteredPriorityQueueStateBackendMetaInfo(metaInfoSnapshot)));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected state type: " + String.valueOf((Object)metaInfoSnapshot.getBackendStateType()) + ".");
                }
            }
            kvStatesById.put(kvStatesById.size(), metaInfoSnapshot);
        }
        return kvStatesById;
    }

    private <T extends HeapPriorityQueueElement & PriorityComparable<? super T>> HeapPriorityQueueSnapshotRestoreWrapper<T> createInternal(RegisteredPriorityQueueStateBackendMetaInfo metaInfo) {
        String stateName = metaInfo.getName();
        KeyGroupedInternalPriorityQueue priorityQueue = this.priorityQueueSetFactory.create(stateName, metaInfo.getElementSerializer());
        return new HeapPriorityQueueSnapshotRestoreWrapper(priorityQueue, metaInfo, KeyExtractorFunction.forKeyedObjects(), this.keyGroupRange, this.numberOfKeyGroups);
    }
}

