/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.typeutils;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.streaming.util.typeutils.FieldAccessor;
import org.apache.flink.streaming.util.typeutils.ScalaProductFieldAccessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class FieldAccessorFactory
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(FieldAccessorFactory.class);
    @Nullable
    private static final ScalaProductFieldAccessorFactory scalaProductFieldAccessorFactory = ScalaProductFieldAccessorFactory.load(LOG);
    private static final String REGEX_FIELD = "[\\p{L}\\p{Digit}_\\$]*";
    private static final String REGEX_NESTED_FIELDS = "([\\p{L}\\p{Digit}_\\$]*)(\\.(.+))?";
    private static final String REGEX_NESTED_FIELDS_WILDCARD = "([\\p{L}\\p{Digit}_\\$]*)(\\.(.+))?|\\*|\\_";
    private static final Pattern PATTERN_NESTED_FIELDS_WILDCARD = Pattern.compile("([\\p{L}\\p{Digit}_\\$]*)(\\.(.+))?|\\*|\\_");

    @Internal
    public static <T, F> FieldAccessor<T, F> getAccessor(TypeInformation<T> typeInfo, int pos, ExecutionConfig config) {
        if (typeInfo instanceof BasicArrayTypeInfo || typeInfo instanceof PrimitiveArrayTypeInfo) {
            return new FieldAccessor.ArrayFieldAccessor(pos, typeInfo);
        }
        if (typeInfo instanceof BasicTypeInfo) {
            if (pos != 0) {
                throw new CompositeType.InvalidFieldReferenceException("The " + Integer.valueOf(pos).toString() + ". field selected on a basic type (" + typeInfo.toString() + "). A field expression on a basic type can only select the 0th field (which means selecting the entire basic type).");
            }
            FieldAccessor.SimpleFieldAccessor<T> result = new FieldAccessor.SimpleFieldAccessor<T>(typeInfo);
            return result;
        }
        if (typeInfo.isTupleType() && ((TupleTypeInfoBase)typeInfo).isCaseClass()) {
            TupleTypeInfoBase tupleTypeInfo = (TupleTypeInfoBase)typeInfo;
            TypeInformation fieldTypeInfo = tupleTypeInfo.getTypeAt(pos);
            if (scalaProductFieldAccessorFactory != null) {
                return scalaProductFieldAccessorFactory.createRecursiveProductFieldAccessor(pos, typeInfo, new FieldAccessor.SimpleFieldAccessor(fieldTypeInfo), config);
            }
            throw new IllegalStateException("Scala products are used but Scala API is not on the classpath.");
        }
        if (typeInfo.isTupleType()) {
            FieldAccessor.SimpleTupleFieldAccessor result = new FieldAccessor.SimpleTupleFieldAccessor(pos, typeInfo);
            return result;
        }
        throw new CompositeType.InvalidFieldReferenceException("Cannot reference field by position on " + typeInfo.toString() + "Referencing a field by position is supported on tuples, case classes, and arrays. Additionally, you can select the 0th field of a primitive/basic type (e.g. int).");
    }

    @Internal
    public static <T, F> FieldAccessor<T, F> getAccessor(TypeInformation<T> typeInfo, String field, ExecutionConfig config) {
        if (typeInfo instanceof BasicArrayTypeInfo || typeInfo instanceof PrimitiveArrayTypeInfo) {
            try {
                return new FieldAccessor.ArrayFieldAccessor(Integer.parseInt(field), typeInfo);
            }
            catch (NumberFormatException ex) {
                throw new CompositeType.InvalidFieldReferenceException("A field expression on an array must be an integer index (that might be given as a string).");
            }
        }
        if (typeInfo instanceof BasicTypeInfo) {
            try {
                int pos = field.equals("*") ? 0 : Integer.parseInt(field);
                return FieldAccessorFactory.getAccessor(typeInfo, pos, config);
            }
            catch (NumberFormatException ex) {
                throw new CompositeType.InvalidFieldReferenceException("You tried to select the field \"" + field + "\" on a " + typeInfo.toString() + ". A field expression on a basic type can only be \"*\" or \"0\" (both of which mean selecting the entire basic type).");
            }
        }
        if (typeInfo instanceof PojoTypeInfo) {
            FieldExpression decomp = FieldAccessorFactory.decomposeFieldExpression(field);
            PojoTypeInfo pojoTypeInfo = (PojoTypeInfo)typeInfo;
            int fieldIndex = pojoTypeInfo.getFieldIndex(decomp.head);
            if (fieldIndex == -1) {
                throw new CompositeType.InvalidFieldReferenceException("Unable to find field \"" + decomp.head + "\" in type " + String.valueOf(typeInfo) + ".");
            }
            PojoField pojoField = pojoTypeInfo.getPojoFieldAt(fieldIndex);
            TypeInformation fieldType = pojoTypeInfo.getTypeAt(fieldIndex);
            if (decomp.tail == null) {
                FieldAccessor.SimpleFieldAccessor innerAccessor = new FieldAccessor.SimpleFieldAccessor(fieldType);
                return new FieldAccessor.PojoFieldAccessor(pojoField.getField(), innerAccessor);
            }
            FieldAccessor<T, F> innerAccessor = FieldAccessorFactory.getAccessor(fieldType, decomp.tail, config);
            return new FieldAccessor.PojoFieldAccessor(pojoField.getField(), innerAccessor);
        }
        if (typeInfo.isTupleType() && ((TupleTypeInfoBase)typeInfo).isCaseClass()) {
            TupleTypeInfoBase tupleTypeInfo = (TupleTypeInfoBase)typeInfo;
            FieldExpression decomp = FieldAccessorFactory.decomposeFieldExpression(field);
            int fieldPos = tupleTypeInfo.getFieldIndex(decomp.head);
            if (fieldPos < 0) {
                throw new CompositeType.InvalidFieldReferenceException("Invalid field selected: " + field);
            }
            if (decomp.tail == null) {
                if (scalaProductFieldAccessorFactory != null) {
                    return scalaProductFieldAccessorFactory.createSimpleProductFieldAccessor(fieldPos, typeInfo, config);
                }
                throw new IllegalStateException("Scala products are used but Scala API is not on the classpath.");
            }
            FieldAccessor<T, F> innerAccessor = FieldAccessorFactory.getAccessor(tupleTypeInfo.getTypeAt(fieldPos), decomp.tail, config);
            if (scalaProductFieldAccessorFactory != null) {
                return scalaProductFieldAccessorFactory.createRecursiveProductFieldAccessor(fieldPos, typeInfo, innerAccessor, config);
            }
            throw new IllegalStateException("Scala products are used but Scala API is not on the classpath.");
        }
        if (typeInfo.isTupleType() && typeInfo instanceof TupleTypeInfo) {
            TupleTypeInfo tupleTypeInfo = (TupleTypeInfo)typeInfo;
            FieldExpression decomp = FieldAccessorFactory.decomposeFieldExpression(field);
            int fieldPos = tupleTypeInfo.getFieldIndex(decomp.head);
            if (fieldPos == -1) {
                try {
                    fieldPos = Integer.parseInt(decomp.head);
                }
                catch (NumberFormatException ex) {
                    throw new CompositeType.InvalidFieldReferenceException("Tried to select field \"" + decomp.head + "\" on " + typeInfo.toString() + " . Only integer values are allowed here.");
                }
            }
            if (decomp.tail == null) {
                FieldAccessor.SimpleTupleFieldAccessor result = new FieldAccessor.SimpleTupleFieldAccessor(fieldPos, tupleTypeInfo);
                return result;
            }
            FieldAccessor<T, F> innerAccessor = FieldAccessorFactory.getAccessor(tupleTypeInfo.getTypeAt(fieldPos), decomp.tail, config);
            FieldAccessor.RecursiveTupleFieldAccessor result = new FieldAccessor.RecursiveTupleFieldAccessor(fieldPos, innerAccessor, tupleTypeInfo);
            return result;
        }
        throw new CompositeType.InvalidFieldReferenceException("Cannot reference field by field expression on " + typeInfo.toString() + "Field expressions are only supported on POJO types, tuples, and case classes. (See the Flink documentation on what is considered a POJO.)");
    }

    private static FieldExpression decomposeFieldExpression(String fieldExpression) {
        Matcher matcher = PATTERN_NESTED_FIELDS_WILDCARD.matcher(fieldExpression);
        if (!matcher.matches()) {
            throw new CompositeType.InvalidFieldReferenceException("Invalid field expression \"" + fieldExpression + "\".");
        }
        String head = matcher.group(0);
        if (head.equals("*") || head.equals("_")) {
            throw new CompositeType.InvalidFieldReferenceException("No wildcards are allowed here.");
        }
        head = matcher.group(1);
        String tail = matcher.group(3);
        return new FieldExpression(head, tail);
    }

    private static class FieldExpression
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String head;
        public String tail;

        FieldExpression(String head, String tail) {
            this.head = head;
            this.tail = tail;
        }
    }
}

