/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery.aeron;

import akka.Done;
import akka.Done$;
import akka.NotUsed;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.ExtendedActorSystem;
import akka.event.Logging$;
import akka.remote.RemoteActorRefProvider;
import akka.remote.RemoteTransportException;
import akka.remote.artery.ArteryTransport;
import akka.remote.artery.ArteryTransport$;
import akka.remote.artery.ArteryTransport$ShuttingDown$;
import akka.remote.artery.Decoder;
import akka.remote.artery.DuplicateHandshakeReq;
import akka.remote.artery.EnvelopeBuffer;
import akka.remote.artery.EnvelopeBufferPool;
import akka.remote.artery.FixedSizePartitionHub;
import akka.remote.artery.FlightRecorderEvents$;
import akka.remote.artery.InboundControlJunction;
import akka.remote.artery.InboundEnvelope;
import akka.remote.artery.OutboundContext;
import akka.remote.artery.aeron.AeronErrorLog;
import akka.remote.artery.aeron.AeronSink;
import akka.remote.artery.aeron.AeronSource;
import akka.remote.artery.aeron.ArteryAeronUdpTransport$;
import akka.remote.artery.aeron.TaskRunner;
import akka.remote.artery.aeron.TaskRunner$;
import akka.remote.artery.compress.NoInboundCompressions$;
import akka.stream.Graph;
import akka.stream.KillSwitches$;
import akka.stream.SharedKillSwitch;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import io.aeron.Aeron;
import io.aeron.AvailableImageHandler;
import io.aeron.CommonContext;
import io.aeron.Image;
import io.aeron.UnavailableImageHandler;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import io.aeron.exceptions.ConductorServiceTimeoutException;
import io.aeron.exceptions.DriverTimeoutException;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.CountersReader;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericCompanion;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ef!B\u0001\u0003\u0001\u0019Q!aF!si\u0016\u0014\u00180Q3s_:,F\r\u001d+sC:\u001c\bo\u001c:u\u0015\t\u0019A!A\u0003bKJ|gN\u0003\u0002\u0006\r\u00051\u0011M\u001d;fefT!a\u0002\u0005\u0002\rI,Wn\u001c;f\u0015\u0005I\u0011\u0001B1lW\u0006\u001c\"\u0001A\u0006\u0011\u00051iQ\"\u0001\u0003\n\u00059!!aD!si\u0016\u0014\u0018\u0010\u0016:b]N\u0004xN\u001d;\t\u0013A\u0001!\u0011!Q\u0001\nIA\u0012aB0tsN$X-\\\u0002\u0001!\t\u0019b#D\u0001\u0015\u0015\t)\u0002\"A\u0003bGR|'/\u0003\u0002\u0018)\t\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[&\u0011\u0011DG\u0001\u0007gf\u001cH/Z7\n\u0005m1!a\u0004*f[>$X\r\u0016:b]N\u0004xN\u001d;\t\u0013u\u0001!\u0011!Q\u0001\ny\u0011\u0013!C0qe>4\u0018\u000eZ3s!\ty\u0002%D\u0001\u0007\u0013\t\tcA\u0001\fSK6|G/Z!di>\u0014(+\u001a4Qe>4\u0018\u000eZ3s\u0013\t\u0019#$\u0001\u0005qe>4\u0018\u000eZ3s\u0011\u0015)\u0003\u0001\"\u0001'\u0003\u0019a\u0014N\\5u}Q\u0019q%\u000b\u0016\u0011\u0005!\u0002Q\"\u0001\u0002\t\u000bA!\u0003\u0019\u0001\n\t\u000bu!\u0003\u0019\u0001\u0010\u0006\t1\u0002\u0001%\f\u0002\n\u0019&4WmQ=dY\u0016\u0004\"AL\u0019\u000f\u0005!z\u0013B\u0001\u0019\u0003\u0003-\tUM]8o'>,(oY3\n\u0005I\u001a$AD!fe>tG*\u001b4fGf\u001cG.\u001a\u0006\u0003a\tAa!\u000e\u0001!\u0002\u00131\u0014aC7fI&\fGI]5wKJ\u00042a\u000e!C\u001b\u0005A$BA\u001d;\u0003\u0019\tGo\\7jG*\u00111\bP\u0001\u000bG>t7-\u001e:sK:$(BA\u001f?\u0003\u0011)H/\u001b7\u000b\u0003}\nAA[1wC&\u0011\u0011\t\u000f\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKB\u00191I\u0012%\u000e\u0003\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0012\u0013aa\u00149uS>t\u0007CA%P\u001b\u0005Q%BA&M\u0003\u0019!'/\u001b<fe*\u00111!\u0014\u0006\u0002\u001d\u0006\u0011\u0011n\\\u0005\u0003!*\u00131\"T3eS\u0006$%/\u001b<fe\"I1\u0001\u0001a\u0001\u0002\u0003\u0006KA\u0015\t\u0003'Rk\u0011\u0001T\u0005\u0003+2\u0013Q!Q3s_:D#!U,\u0011\u0005\rC\u0016BA-E\u0005!1x\u000e\\1uS2,\u0007\"C.\u0001\u0001\u0004\u0005\t\u0015)\u0003]\u0003A\tWM]8o\u0007>,h\u000e^3s)\u0006\u001c8\u000e\u0005\u0002\u0014;&\u0011a\f\u0006\u0002\f\u0007\u0006t7-\u001a7mC\ndW\r\u000b\u0002[/\"I\u0011\r\u0001a\u0001\u0002\u0003\u0006K\u0001X\u0001\u0012C\u0016\u0014xN\\#se>\u0014Hj\\4UCN\\\u0007F\u00011X\u0011%!\u0007\u00011A\u0001B\u0003&Q-A\u0007bKJ|g.\u0012:s_Jdun\u001a\t\u0003Q\u0019L!a\u001a\u0002\u0003\u001b\u0005+'o\u001c8FeJ|'\u000fT8hQ\t\u0019w\u000bC\u0004k\u0001\t\u0007I\u0011B6\u0002\u0015Q\f7o\u001b*v]:,'/F\u0001m!\tAS.\u0003\u0002o\u0005\tQA+Y:l%Vtg.\u001a:\t\rA\u0004\u0001\u0015!\u0003m\u0003-!\u0018m]6Sk:tWM\u001d\u0011\t\u000bI\u0004A\u0011B:\u0002\u001d%t'm\\;oI\u000eC\u0017M\u001c8fYV\tA\u000f\u0005\u0002vq:\u00111I^\u0005\u0003o\u0012\u000ba\u0001\u0015:fI\u00164\u0017BA={\u0005\u0019\u0019FO]5oO*\u0011q\u000f\u0012\u0005\u0006y\u0002!I!`\u0001\u0010_V$(m\\;oI\u000eC\u0017M\u001c8fYR\u0011AO \u0005\u0007\u007fn\u0004\r!!\u0001\u0002\u0003\u0005\u00042aEA\u0002\u0013\r\t)\u0001\u0006\u0002\b\u0003\u0012$'/Z:t\u0011\u001d\tI\u0001\u0001C)\u0003\u0017\tab\u001d;beR$&/\u00198ta>\u0014H\u000f\u0006\u0002\u0002\u000eA\u00191)a\u0004\n\u0007\u0005EAI\u0001\u0003V]&$\bbBA\u000b\u0001\u0011%\u00111B\u0001\u0011gR\f'\u000f^'fI&\fGI]5wKJDa!!\u0007\u0001\t\u0013\u0019\u0018\u0001C1fe>tG)\u001b:\t\u000f\u0005u\u0001\u0001\"\u0003\u0002\f\u0005y1\u000f^8q\u001b\u0016$\u0017.\u0019#sSZ,'\u000fC\u0004\u0002\"\u0001!I!a\u0003\u0002\u0015M$\u0018M\u001d;BKJ|g\u000eC\u0004\u0002&\u0001!I!a\u0003\u0002/\tdwnY6V]RLGn\u00115b]:,G.Q2uSZ,\u0007bBA\u0015\u0001\u0011%\u00111B\u0001\u0013gR\f'\u000f^!fe>tWI\u001d:pe2{w\rC\u0004\u0002.\u0001!I!a\u0003\u0002)M$\u0018M\u001d;BKJ|gnQ8v]R,'\u000fT8h\u0011\u001d\t\t\u0004\u0001C)\u0003g\tQc\\;uE>,h\u000e\u001a+sC:\u001c\bo\u001c:u'&t7\u000e\u0006\u0005\u00026\u0005u\u0013qMA9!!\t9$!\u0011\u0002F\u0005-SBAA\u001d\u0015\u0011\tY$!\u0010\u0002\u0011M\u001c\u0017\r\\1eg2T1!a\u0010\t\u0003\u0019\u0019HO]3b[&!\u00111IA\u001d\u0005\u0011\u0019\u0016N\\6\u0011\u00071\t9%C\u0002\u0002J\u0011\u0011a\"\u00128wK2|\u0007/\u001a\"vM\u001a,'\u000f\u0005\u0004\u0002N\u0005E\u0013QK\u0007\u0003\u0003\u001fR!a\u000f#\n\t\u0005M\u0013q\n\u0002\u0007\rV$XO]3\u0011\t\u0005]\u0013\u0011L\u0007\u0002\u0011%\u0019\u00111\f\u0005\u0003\t\u0011{g.\u001a\u0005\t\u0003?\ny\u00031\u0001\u0002b\u0005yq.\u001e;c_VtGmQ8oi\u0016DH\u000fE\u0002\r\u0003GJ1!!\u001a\u0005\u0005=yU\u000f\u001e2pk:$7i\u001c8uKb$\b\u0002CA5\u0003_\u0001\r!a\u001b\u0002\u0011M$(/Z1n\u0013\u0012\u00042aQA7\u0013\r\ty\u0007\u0012\u0002\u0004\u0013:$\b\u0002CA:\u0003_\u0001\r!!\u001e\u0002\u0015\t,hMZ3s!>|G\u000eE\u0002\r\u0003oJ1!!\u001f\u0005\u0005I)eN^3m_B,')\u001e4gKJ\u0004vn\u001c7\t\u000f\u0005u\u0004\u0001\"\u0003\u0002\u0000\u0005Y\u0011-\u001a:p]N{WO]2f)\u0019\t\t)a\"\u0002\nB9\u0011qGAB\u0003\u000bj\u0013\u0002BAC\u0003s\u0011aaU8ve\u000e,\u0007\u0002CA5\u0003w\u0002\r!a\u001b\t\u0011\u0005-\u00151\u0010a\u0001\u0003k\nA\u0001]8pY\"9\u0011q\u0012\u0001\u0005\n\u0005E\u0015aG1fe>t7k\\;sG\u0016\u001c\u0006/\u001b8oS:<7\u000b\u001e:bi\u0016<\u00170\u0006\u0002\u0002l!9\u0011Q\u0013\u0001\u0005R\u0005-\u0011!\u0005:v]&s'm\\;oIN#(/Z1ng\"9\u0011\u0011\u0014\u0001\u0005\n\u0005-\u0011a\u0006:v]&s'm\\;oI\u000e{g\u000e\u001e:pYN#(/Z1n\u0011\u001d\ti\n\u0001C\u0005\u0003\u0017\t\u0001E];o\u0013:\u0014w.\u001e8e\u001fJ$\u0017N\\1ss6+7o]1hKN\u001cFO]3b[\"9\u0011\u0011\u0015\u0001\u0005\n\u0005-\u0011!\b:v]&s'm\\;oI2\u000b'oZ3NKN\u001c\u0018mZ3t'R\u0014X-Y7\t\u000f\u0005\u0015\u0006\u0001\"\u0003\u0002(\u0006)R\u000f\u001d3bi\u0016\u001cFO]3b[6\u000bGOV1mk\u0016\u001cH\u0003CA\u0007\u0003S\u000bY+a,\t\u0011\u0005%\u00141\u0015a\u0001\u0003WBq!!,\u0002$\u0002\u0007Q&\u0001\u000bbKJ|gnU8ve\u000e,G*\u001b4fGf\u001cG.\u001a\u0005\t\u0003c\u000b\u0019\u000b1\u0001\u0002L\u0005I1m\\7qY\u0016$X\r\u001a\u0005\b\u0003k\u0003A\u0011KA\\\u0003E\u0019\b.\u001e;e_^tGK]1ogB|'\u000f\u001e\u000b\u0003\u0003\u0017\u0002")
public class ArteryAeronUdpTransport
extends ArteryTransport {
    public final AtomicReference<Option<MediaDriver>> akka$remote$artery$aeron$ArteryAeronUdpTransport$$mediaDriver = new AtomicReference<None$>(None$.MODULE$);
    public volatile Aeron akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron;
    public volatile Cancellable akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask;
    public volatile Cancellable akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask;
    public volatile AeronErrorLog akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLog;
    private final TaskRunner akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner = new TaskRunner(this.system(), this.settings().Advanced().IdleCpuLevel());

    public TaskRunner akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner() {
        return this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner;
    }

    private String inboundChannel() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aeron:udp?endpoint=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.bindAddress().address().host().get(), this.bindAddress().address().port().get()}));
    }

    private String outboundChannel(Address a) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aeron:udp?endpoint=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{a.host().get(), a.port().get()}));
    }

    @Override
    public void startTransport() {
        this.startMediaDriver();
        this.startAeron();
        this.startAeronErrorLog();
        this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_AeronErrorLogStarted(), FlightRecorderEvents$.MODULE$.NoMetaData());
        if (this.settings().LogAeronCounters()) {
            this.startAeronCounterLog();
        }
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().start();
        this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_TaskRunnerStarted(), FlightRecorderEvents$.MODULE$.NoMetaData());
    }

    private void startMediaDriver() {
        if (this.settings().Advanced().EmbeddedMediaDriver()) {
            MediaDriver.Context context;
            MediaDriver.Context driverContext = new MediaDriver.Context();
            if (new StringOps(Predef$.MODULE$.augmentString(this.settings().Advanced().AeronDirectoryName())).nonEmpty()) {
                context = driverContext.aeronDirectoryName(this.settings().Advanced().AeronDirectoryName());
            } else {
                String uniquePart = UUID.randomUUID().toString();
                String randomName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CommonContext.AERON_DIR_PROP_DEFAULT, this.system().name(), uniquePart}));
                context = driverContext.aeronDirectoryName(randomName);
            }
            driverContext.clientLivenessTimeoutNs(this.settings().Advanced().ClientLivenessTimeout().toNanos());
            driverContext.imageLivenessTimeoutNs(this.settings().Advanced().ImageLivenessTimeout().toNanos());
            driverContext.driverTimeoutMs(this.settings().Advanced().DriverTimeout().toMillis());
            int idleCpuLevel = this.settings().Advanced().IdleCpuLevel();
            MediaDriver.Context context2 = idleCpuLevel == 10 ? driverContext.threadingMode(ThreadingMode.DEDICATED).conductorIdleStrategy((IdleStrategy)new BackoffIdleStrategy(1L, 1L, 1L, 1L)).receiverIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).senderIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)) : (idleCpuLevel == 1 ? driverContext.threadingMode(ThreadingMode.SHARED).sharedIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)) : (idleCpuLevel <= 7 ? driverContext.threadingMode(ThreadingMode.SHARED_NETWORK).sharedNetworkIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)) : driverContext.threadingMode(ThreadingMode.DEDICATED).receiverIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).senderIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel))));
            MediaDriver driver = MediaDriver.launchEmbedded((MediaDriver.Context)driverContext);
            this.log().info("Started embedded media driver in directory [{}]", (Object)driver.aeronDirectoryName());
            this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_MediaDriverStarted(), driver.aeronDirectoryName());
            if (!this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$mediaDriver.compareAndSet((Option<MediaDriver>)None$.MODULE$, (Option<MediaDriver>)new Some((Object)driver))) {
                throw new IllegalStateException("media driver started more than once");
            }
        }
    }

    private String aeronDir() {
        Option<MediaDriver> option;
        block4: {
            String string;
            block3: {
                block2: {
                    option = this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$mediaDriver.get();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    MediaDriver driver = (MediaDriver)some.x();
                    string = driver.aeronDirectoryName();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                string = this.settings().Advanced().AeronDirectoryName();
            }
            return string;
        }
        throw new MatchError(option);
    }

    public void akka$remote$artery$aeron$ArteryAeronUdpTransport$$stopMediaDriver() {
        Option<MediaDriver> maybeDriver = this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$mediaDriver.getAndSet((Option<MediaDriver>)None$.MODULE$);
        maybeDriver.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            public final void apply(MediaDriver driver) {
                try {
                    driver.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.$outer.log().warning("Couldn't close Aeron embedded media driver due to [{}]", (Object)e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                try {
                    if (this.$outer.settings().Advanced().DeleteAeronDirectory()) {
                        IoUtil.delete((File)new File(driver.aeronDirectoryName()), (boolean)false);
                        this.$outer.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_MediaFileDeleted(), FlightRecorderEvents$.MODULE$.NoMetaData());
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable3);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.$outer.log().warning("Couldn't delete Aeron embedded media driver files in [{}] due to [{}]", (Object)driver.aeronDirectoryName(), (Object)e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void startAeron() {
        Aeron.Context ctx = new Aeron.Context();
        ctx.driverTimeoutMs(this.settings().Advanced().DriverTimeout().toMillis());
        ctx.availableImageHandler(new AvailableImageHandler(this){
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            public void onAvailableImage(Image img) {
                if (this.$outer.log().isDebugEnabled()) {
                    this.$outer.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"onAvailableImage from ", " session ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{img.sourceIdentity(), BoxesRunTime.boxToInteger((int)img.sessionId())})));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ctx.unavailableImageHandler(new UnavailableImageHandler(this){
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            public void onUnavailableImage(Image img) {
                if (this.$outer.log().isDebugEnabled()) {
                    this.$outer.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"onUnavailableImage from ", " session ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{img.sourceIdentity(), BoxesRunTime.boxToInteger((int)img.sessionId())})));
                }
                ((MapLike)this.$outer.streamMatValues().get()).valuesIterator().foreach((Function1)new Serializable(this, img){
                    public static final long serialVersionUID = 0L;
                    private final Image img$1;

                    public final void apply(ArteryTransport.InboundStreamMatValues<AeronSource.AeronLifecycle> x0$1) {
                        ArteryTransport.InboundStreamMatValues<AeronSource.AeronLifecycle> inboundStreamMatValues = x0$1;
                        if (inboundStreamMatValues != null) {
                            AeronSource.AeronLifecycle resourceLife = inboundStreamMatValues.lifeCycle();
                            resourceLife.onUnavailableImage(this.img$1.sessionId());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(inboundStreamMatValues);
                    }
                    {
                        this.img$1 = img$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ctx.errorHandler(new ErrorHandler(this){
            private final AtomicBoolean fatalErrorOccured;
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            private AtomicBoolean fatalErrorOccured() {
                return this.fatalErrorOccured;
            }

            public void onError(Throwable cause) {
                Throwable throwable = cause;
                if (throwable instanceof ConductorServiceTimeoutException) {
                    ConductorServiceTimeoutException conductorServiceTimeoutException = (ConductorServiceTimeoutException)throwable;
                    this.handleFatalError((Throwable)conductorServiceTimeoutException);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (throwable instanceof DriverTimeoutException) {
                    DriverTimeoutException driverTimeoutException = (DriverTimeoutException)throwable;
                    this.handleFatalError(driverTimeoutException);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (throwable instanceof ArteryTransport.AeronTerminated) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.$outer.log().error(cause, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aeron error, ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cause})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            private void handleFatalError(Throwable cause) {
                if (this.fatalErrorOccured().compareAndSet(false, true)) {
                    if (this.$outer.isShutdown()) {
                        return;
                    }
                    this.$outer.log().error(cause, "Fatal Aeron error {}. Have to terminate ActorSystem because it lost contact with the {} Aeron media driver. Possible configuration properties to mitigate the problem are 'client-liveness-timeout' or 'driver-timeout'. {}", (Object)Logging$.MODULE$.simpleName((Object)cause), (Object)(this.$outer.settings().Advanced().EmbeddedMediaDriver() ? "embedded" : "external"), (Object)cause);
                    this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().stop();
                    this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask.cancel();
                    Object object = this.$outer.settings().LogAeronCounters() ? BoxesRunTime.boxToBoolean((boolean)this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask.cancel()) : BoxedUnit.UNIT;
                    this.$outer.system().terminate();
                    throw new ArteryTransport.AeronTerminated(cause);
                }
                throw new ArteryTransport.AeronTerminated(cause);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fatalErrorOccured = new AtomicBoolean();
            }
        });
        ctx.aeronDirectoryName(this.aeronDir());
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron = Aeron.connect((Aeron.Context)ctx);
    }

    private void blockUntilChannelActive() {
        AeronSource.AeronLifecycle aeronLifecyle = (AeronSource.AeronLifecycle)((ArteryTransport.InboundStreamMatValues)((MapLike)this.streamMatValues().get()).apply((Object)BoxesRunTime.boxToInteger((int)ArteryTransport$.MODULE$.ControlStreamId()))).lifeCycle();
        int waitInterval = 200;
        long retries = package$.MODULE$.max(1L, this.settings().Bind().BindTimeout().toMillis() / (long)waitInterval);
        this.retry$1(retries, aeronLifecyle, waitInterval);
    }

    private void startAeronErrorLog() {
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLog = new AeronErrorLog(new File(this.aeronDir(), "cnc.dat"), this.log());
        AtomicLong lastTimestamp = new AtomicLong(0L);
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask = this.system().scheduler().schedule(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), (Function0)new Serializable(this, lastTimestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArteryAeronUdpTransport $outer;
            private final AtomicLong lastTimestamp$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (!this.$outer.isShutdown()) {
                    long newLastTimestamp = this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLog.logErrors(this.$outer.log(), this.lastTimestamp$1.get());
                    this.lastTimestamp$1.set(newLastTimestamp + 1L);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.lastTimestamp$1 = lastTimestamp$1;
            }
        }, (ExecutionContext)this.system().dispatcher());
    }

    private void startAeronCounterLog() {
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask = this.system().scheduler().schedule(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (!this.$outer.isShutdown() && this.$outer.log().isDebugEnabled()) {
                    this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.countersReader().forEach(new CountersReader.MetaData(this){
                        private final /* synthetic */ $anonfun$startAeronCounterLog$1 $outer;

                        public void accept(int counterId, int typeId, DirectBuffer keyBuffer, String label) {
                            long value = this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$anonfun$$$outer().akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.countersReader().getCounterValue(counterId);
                            this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$anonfun$$$outer().log().debug("Aeron Counter {}: {} {}]", (Object)BoxesRunTime.boxToInteger((int)counterId), (Object)BoxesRunTime.boxToLong((long)value), (Object)label);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
            }

            public /* synthetic */ ArteryAeronUdpTransport akka$remote$artery$aeron$ArteryAeronUdpTransport$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)this.system().dispatcher());
    }

    @Override
    public Sink<EnvelopeBuffer, Future<Done>> outboundTransportSink(OutboundContext outboundContext, int streamId, EnvelopeBufferPool bufferPool) {
        FiniteDuration giveUpAfter = streamId == ArteryTransport$.MODULE$.ControlStreamId() ? this.settings().Advanced().GiveUpSystemMessageAfter() : this.settings().Advanced().GiveUpMessageAfter();
        return Sink$.MODULE$.fromGraph((Graph)new AeronSink(this.outboundChannel(outboundContext.remoteAddress()), streamId, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner(), bufferPool, (Duration)giveUpAfter, this.createFlightRecorderEventSink(this.createFlightRecorderEventSink$default$1())));
    }

    private Source<EnvelopeBuffer, AeronSource.AeronLifecycle> aeronSource(int streamId, EnvelopeBufferPool pool) {
        return Source$.MODULE$.fromGraph((Graph)new AeronSource(this.inboundChannel(), streamId, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner(), pool, this.createFlightRecorderEventSink(this.createFlightRecorderEventSink$default$1()), this.aeronSourceSpinningStrategy()));
    }

    private int aeronSourceSpinningStrategy() {
        return this.settings().Advanced().InboundLanes() > 1 || this.settings().Advanced().IdleCpuLevel() < 5 ? 0 : 50 * this.settings().Advanced().IdleCpuLevel() - 240;
    }

    @Override
    public void runInboundStreams() {
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$runInboundControlStream();
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$runInboundOrdinaryMessagesStream();
        if (this.largeMessageChannelEnabled()) {
            this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$runInboundLargeMessagesStream();
        }
        this.blockUntilChannelActive();
    }

    public void akka$remote$artery$aeron$ArteryAeronUdpTransport$$runInboundControlStream() {
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        Tuple3 tuple3 = (Tuple3)this.aeronSource(ArteryTransport$.MODULE$.ControlStreamId(), this.envelopeBufferPool()).via(this.inboundFlow(this.settings(), NoInboundCompressions$.MODULE$)).toMat(this.inboundControlSink(), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<AeronSource.AeronLifecycle, InboundControlJunction.ControlMessageSubject, Future<Done>> apply(AeronSource.AeronLifecycle x0$2, Tuple2<InboundControlJunction.ControlMessageSubject, Future<Done>> x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$2, x1$1);
                if (tuple2 != null) {
                    AeronSource.AeronLifecycle a = (AeronSource.AeronLifecycle)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        InboundControlJunction.ControlMessageSubject c = (InboundControlJunction.ControlMessageSubject)tuple22._1();
                        Future d = (Future)tuple22._2();
                        Tuple3 tuple3 = new Tuple3((Object)a, (Object)c, (Object)d);
                        return tuple3;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        }).run(this.controlMaterializer());
        if (tuple3 != null) {
            Tuple3 tuple32;
            AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple3._1();
            InboundControlJunction.ControlMessageSubject ctrl = (InboundControlJunction.ControlMessageSubject)tuple3._2();
            Future completed = (Future)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)resourceLife, (Object)ctrl, (Object)completed);
            AeronSource.AeronLifecycle resourceLife2 = (AeronSource.AeronLifecycle)tuple33._1();
            InboundControlJunction.ControlMessageSubject ctrl2 = (InboundControlJunction.ControlMessageSubject)tuple33._2();
            Future completed2 = (Future)tuple33._3();
            this.attachControlMessageObserver(ctrl2);
            this.updateStreamMatValues(ArteryTransport$.MODULE$.ControlStreamId(), resourceLife2, (Future<Done>)completed2);
            this.attachInboundStreamRestart("Inbound control stream", (Future<Done>)completed2, (Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ArteryAeronUdpTransport $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$runInboundControlStream();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public void akka$remote$artery$aeron$ArteryAeronUdpTransport$$runInboundOrdinaryMessagesStream() {
        Tuple3 tuple3;
        block7: {
            Tuple3 tuple32;
            block6: {
                Tuple3 tuple33;
                Tuple3 tuple34;
                block5: {
                    if (this.isShutdown()) {
                        throw ArteryTransport$ShuttingDown$.MODULE$;
                    }
                    if (this.inboundLanes() != 1) break block5;
                    tuple34 = (Tuple3)this.aeronSource(ArteryTransport$.MODULE$.OrdinaryStreamId(), this.envelopeBufferPool()).viaMat(this.inboundFlow(this.settings(), this._inboundCompressions()), Keep$.MODULE$.both()).toMat(this.inboundSink(this.envelopeBufferPool()), (Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple3<AeronSource.AeronLifecycle, Decoder.InboundCompressionAccess, Future<Done>> apply(Tuple2<AeronSource.AeronLifecycle, Decoder.InboundCompressionAccess> x0$3, Future<Done> x1$2) {
                            Tuple2 tuple2 = new Tuple2(x0$3, x1$2);
                            if (tuple2 != null) {
                                Tuple2 tuple22 = (Tuple2)tuple2._1();
                                Future c = (Future)tuple2._2();
                                if (tuple22 != null) {
                                    AeronSource.AeronLifecycle a = (AeronSource.AeronLifecycle)tuple22._1();
                                    Decoder.InboundCompressionAccess b = (Decoder.InboundCompressionAccess)tuple22._2();
                                    Tuple3 tuple3 = new Tuple3((Object)a, (Object)b, (Object)c);
                                    return tuple3;
                                }
                            }
                            throw new MatchError((Object)tuple2);
                        }
                    }).run(this.materializer());
                    break block6;
                }
                SharedKillSwitch laneKillSwitch = KillSwitches$.MODULE$.shared("laneKillSwitch");
                Source laneSource = this.aeronSource(ArteryTransport$.MODULE$.OrdinaryStreamId(), this.envelopeBufferPool()).via(laneKillSwitch.flow()).viaMat(this.inboundFlow(this.settings(), this._inboundCompressions()), Keep$.MODULE$.both()).via((Graph)Flow$.MODULE$.fromGraph((Graph)new DuplicateHandshakeReq(this.inboundLanes(), this, this.system(), this.envelopeBufferPool())));
                tuple3 = (Tuple3)laneSource.toMat((Graph)Sink$.MODULE$.fromGraph(new FixedSizePartitionHub<InboundEnvelope>(this.inboundLanePartitioner(), this.inboundLanes(), this.settings().Advanced().InboundHubBufferSize())), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<AeronSource.AeronLifecycle, Decoder.InboundCompressionAccess, Source<InboundEnvelope, NotUsed>> apply(Tuple2<AeronSource.AeronLifecycle, Decoder.InboundCompressionAccess> x0$4, Source<InboundEnvelope, NotUsed> x1$3) {
                        Tuple2 tuple2 = new Tuple2(x0$4, x1$3);
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            Source c = (Source)tuple2._2();
                            if (tuple22 != null) {
                                AeronSource.AeronLifecycle a = (AeronSource.AeronLifecycle)tuple22._1();
                                Decoder.InboundCompressionAccess b = (Decoder.InboundCompressionAccess)tuple22._2();
                                Tuple3 tuple3 = new Tuple3((Object)a, (Object)b, (Object)c);
                                return tuple3;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                }).run(this.materializer());
                if (tuple3 == null) break block7;
                AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple3._1();
                Decoder.InboundCompressionAccess compressionAccess = (Decoder.InboundCompressionAccess)tuple3._2();
                Source laneHub = (Source)tuple3._3();
                Tuple3 tuple35 = tuple33 = new Tuple3((Object)resourceLife, (Object)compressionAccess, (Object)laneHub);
                AeronSource.AeronLifecycle resourceLife2 = (AeronSource.AeronLifecycle)tuple35._1();
                Decoder.InboundCompressionAccess compressionAccess2 = (Decoder.InboundCompressionAccess)tuple35._2();
                Source laneHub2 = (Source)tuple35._3();
                Sink<InboundEnvelope, Future<Done>> lane = this.inboundSink(this.envelopeBufferPool());
                Vector completedValues = (Vector)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.inboundLanes()).iterator().map((Function1)new Serializable(this, laneHub2, lane){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ArteryAeronUdpTransport $outer;
                    private final Source laneHub$1;
                    private final Sink lane$1;

                    public final Future<Done> apply(int x$3) {
                        return (Future)this.laneHub$1.toMat((Graph)this.lane$1, Keep$.MODULE$.right()).run(this.$outer.materializer());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.laneHub$1 = laneHub$1;
                        this.lane$1 = lane$1;
                    }
                }).to(akka.util.ccompat.package$.MODULE$.genericCompanionToCBF((GenericCompanion)Vector$.MODULE$));
                Future$.MODULE$.firstCompletedOf((TraversableOnce)completedValues, (ExecutionContext)this.system().dispatcher()).failed().foreach((Function1)new Serializable(this, laneKillSwitch){
                    public static final long serialVersionUID = 0L;
                    private final SharedKillSwitch laneKillSwitch$1;

                    public final void apply(Throwable reason) {
                        this.laneKillSwitch$1.abort(reason);
                    }
                    {
                        this.laneKillSwitch$1 = laneKillSwitch$1;
                    }
                }, (ExecutionContext)this.system().dispatcher());
                Future allCompleted = Future$.MODULE$.sequence((TraversableOnce)completedValues, Vector$.MODULE$.canBuildFrom(), (ExecutionContext)this.system().dispatcher()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Done$ apply(Vector<Done> x$4) {
                        return Done$.MODULE$;
                    }
                }, (ExecutionContext)this.system().dispatcher());
                tuple34 = tuple32 = new Tuple3((Object)resourceLife2, (Object)compressionAccess2, (Object)allCompleted);
            }
            if (tuple32 != null) {
                Tuple3 tuple36;
                AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple32._1();
                Decoder.InboundCompressionAccess inboundCompressionAccess = (Decoder.InboundCompressionAccess)tuple32._2();
                Future completed = (Future)tuple32._3();
                Tuple3 tuple37 = tuple36 = new Tuple3((Object)resourceLife, (Object)inboundCompressionAccess, (Object)completed);
                AeronSource.AeronLifecycle resourceLife3 = (AeronSource.AeronLifecycle)tuple37._1();
                Decoder.InboundCompressionAccess inboundCompressionAccess2 = (Decoder.InboundCompressionAccess)tuple37._2();
                Future completed2 = (Future)tuple37._3();
                this.setInboundCompressionAccess(inboundCompressionAccess2);
                this.updateStreamMatValues(ArteryTransport$.MODULE$.OrdinaryStreamId(), resourceLife3, (Future<Done>)completed2);
                this.attachInboundStreamRestart("Inbound message stream", (Future<Done>)completed2, (Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ArteryAeronUdpTransport $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$runInboundOrdinaryMessagesStream();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return;
            }
            throw new MatchError((Object)tuple32);
        }
        throw new MatchError((Object)tuple3);
    }

    public void akka$remote$artery$aeron$ArteryAeronUdpTransport$$runInboundLargeMessagesStream() {
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        Tuple2 tuple2 = (Tuple2)this.aeronSource(ArteryTransport$.MODULE$.LargeStreamId(), this.largeEnvelopeBufferPool()).via(this.inboundLargeFlow(this.settings())).toMat(this.inboundSink(this.largeEnvelopeBufferPool()), Keep$.MODULE$.both()).run(this.materializer());
        if (tuple2 != null) {
            Tuple2 tuple22;
            AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple2._1();
            Future completed = (Future)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)resourceLife, (Object)completed);
            AeronSource.AeronLifecycle resourceLife2 = (AeronSource.AeronLifecycle)tuple23._1();
            Future completed2 = (Future)tuple23._2();
            this.updateStreamMatValues(ArteryTransport$.MODULE$.LargeStreamId(), resourceLife2, (Future<Done>)completed2);
            this.attachInboundStreamRestart("Inbound large message stream", (Future<Done>)completed2, (Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ArteryAeronUdpTransport $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$runInboundLargeMessagesStream();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private void updateStreamMatValues(int streamId, AeronSource.AeronLifecycle aeronSourceLifecycle, Future<Done> completed) {
        ExecutionContextExecutor ec = this.materializer().executionContext();
        this.updateStreamMatValues(streamId, new ArteryTransport.InboundStreamMatValues<Object>(aeronSourceLifecycle, (Future<Done>)completed.recover((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Done$ done$ = Done$.MODULE$;
                return (B1)done$;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
        }, (ExecutionContext)ec)));
    }

    @Override
    public Future<Done> shutdownTransport() {
        return this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().stop().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            public final Done$ apply(Done x$7) {
                this.$outer.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_Stopped(), FlightRecorderEvents$.MODULE$.NoMetaData());
                if (this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask != null) {
                    this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask.cancel();
                    this.$outer.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_AeronErrorLogTaskStopped(), FlightRecorderEvents$.MODULE$.NoMetaData());
                }
                if (this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron != null) {
                    this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.close();
                }
                if (this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLog != null) {
                    this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLog.close();
                }
                if (this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$mediaDriver.get().isDefined()) {
                    this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$stopMediaDriver();
                }
                return Done$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)this.system().dispatcher());
    }

    /*
     * WARNING - void declaration
     */
    private final void retry$1(long retries, AeronSource.AeronLifecycle aeronLifecyle$1, int waitInterval$1) {
        while (true) {
            void var6_4;
            long status;
            if ((status = BoxesRunTime.unboxToLong((Object)Await$.MODULE$.result(aeronLifecyle$1.channelEndpointStatus(), (Duration)this.settings().Bind().BindTimeout()))) == 1L) {
                this.log().debug("Inbound channel is now active");
                return;
            }
            if (var6_4 == -1L) {
                this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLog.logErrors(this.log(), 0L);
                this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$stopMediaDriver();
                throw new RemoteTransportException("Inbound Aeron channel is in errored state. See Aeron logs for details.");
            }
            if (var6_4 != 0L || retries <= 0L) break;
            Thread.sleep(waitInterval$1);
            --retries;
        }
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLog.logErrors(this.log(), 0L);
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$stopMediaDriver();
        throw new RemoteTransportException("Timed out waiting for Aeron transport to bind. See Aeoron logs.");
    }

    public ArteryAeronUdpTransport(ExtendedActorSystem _system, RemoteActorRefProvider _provider) {
        super(_system, _provider);
    }
}

