/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.PermanentBlobCache;
import org.apache.flink.runtime.blob.TransientBlobCache;
import org.apache.flink.util.Preconditions;

public class BlobCacheService
implements BlobService {
    private final PermanentBlobCache permanentBlobCache;
    private final TransientBlobCache transientBlobCache;

    public BlobCacheService(Configuration blobClientConfig, BlobView blobView, @Nullable InetSocketAddress serverAddress) throws IOException {
        this(new PermanentBlobCache(blobClientConfig, blobView, serverAddress), new TransientBlobCache(blobClientConfig, serverAddress));
    }

    public BlobCacheService(PermanentBlobCache permanentBlobCache, TransientBlobCache transientBlobCache) {
        this.permanentBlobCache = (PermanentBlobCache)Preconditions.checkNotNull((Object)permanentBlobCache);
        this.transientBlobCache = (TransientBlobCache)Preconditions.checkNotNull((Object)transientBlobCache);
    }

    @Override
    public PermanentBlobCache getPermanentBlobService() {
        return this.permanentBlobCache;
    }

    @Override
    public TransientBlobCache getTransientBlobService() {
        return this.transientBlobCache;
    }

    public void setBlobServerAddress(InetSocketAddress blobServerAddress) {
        this.permanentBlobCache.setBlobServerAddress(blobServerAddress);
        this.transientBlobCache.setBlobServerAddress(blobServerAddress);
    }

    @Override
    public void close() throws IOException {
        this.permanentBlobCache.close();
        this.transientBlobCache.close();
    }

    @Override
    public int getPort() {
        return this.permanentBlobCache.getPort();
    }
}

