/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;

public class ContaineredTaskManagerParameters
implements Serializable {
    private static final long serialVersionUID = -3096987654278064670L;
    private final int numSlots;
    private final HashMap<String, String> taskManagerEnv;
    private final TaskExecutorProcessSpec taskExecutorProcessSpec;

    public ContaineredTaskManagerParameters(TaskExecutorProcessSpec taskExecutorProcessSpec, int numSlots, HashMap<String, String> taskManagerEnv) {
        this.taskExecutorProcessSpec = taskExecutorProcessSpec;
        this.numSlots = numSlots;
        this.taskManagerEnv = taskManagerEnv;
    }

    public TaskExecutorProcessSpec getTaskExecutorProcessSpec() {
        return this.taskExecutorProcessSpec;
    }

    public int numSlots() {
        return this.numSlots;
    }

    public Map<String, String> taskManagerEnv() {
        return this.taskManagerEnv;
    }

    public String toString() {
        return "TaskManagerParameters {taskExecutorProcessSpec=" + this.taskExecutorProcessSpec + ", numSlots=" + this.numSlots + ", taskManagerEnv=" + this.taskManagerEnv + '}';
    }

    public static ContaineredTaskManagerParameters create(Configuration config, TaskExecutorProcessSpec taskExecutorProcessSpec, int numSlots) {
        HashMap<String, String> envVars = new HashMap<String, String>();
        String prefix = "containerized.taskmanager.env.";
        for (String key : config.keySet()) {
            if (!key.startsWith("containerized.taskmanager.env.") || key.length() <= "containerized.taskmanager.env.".length()) continue;
            String envVarKey = key.substring("containerized.taskmanager.env.".length());
            envVars.put(envVarKey, config.getString(key, null));
        }
        return new ContaineredTaskManagerParameters(taskExecutorProcessSpec, numSlots, envVars);
    }
}

