/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.Collection;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.dispatcher.DefaultJobManagerRunnerFactory;
import org.apache.flink.runtime.dispatcher.DispatcherFactory;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.dispatcher.DispatcherServices;
import org.apache.flink.runtime.dispatcher.MiniDispatcher;
import org.apache.flink.runtime.dispatcher.PartialDispatcherServicesWithJobGraphStore;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.shaded.guava18.com.google.common.collect.Iterables;

public enum JobDispatcherFactory implements DispatcherFactory
{
    INSTANCE;


    @Override
    public MiniDispatcher createDispatcher(RpcService rpcService, DispatcherId fencingToken, Collection<JobGraph> recoveredJobs, PartialDispatcherServicesWithJobGraphStore partialDispatcherServicesWithJobGraphStore) throws Exception {
        JobGraph jobGraph = (JobGraph)Iterables.getOnlyElement(recoveredJobs);
        Configuration configuration = partialDispatcherServicesWithJobGraphStore.getConfiguration();
        String executionModeValue = configuration.getString(ClusterEntrypoint.EXECUTION_MODE);
        ClusterEntrypoint.ExecutionMode executionMode = ClusterEntrypoint.ExecutionMode.valueOf(executionModeValue);
        return new MiniDispatcher(rpcService, this.getEndpointId(), fencingToken, DispatcherServices.from(partialDispatcherServicesWithJobGraphStore, DefaultJobManagerRunnerFactory.INSTANCE), jobGraph, executionMode);
    }
}

