/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailoverStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailoverTopology;
import org.apache.flink.runtime.executiongraph.failover.flip1.ResultPartitionAvailabilityChecker;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.topology.Vertex;
import org.apache.flink.util.IterableUtils;
import org.apache.flink.util.Preconditions;

public class RestartAllStrategy
implements FailoverStrategy {
    private final FailoverTopology<?, ?> topology;

    public RestartAllStrategy(FailoverTopology<?, ?> topology) {
        this.topology = (FailoverTopology)Preconditions.checkNotNull(topology);
    }

    @Override
    public Set<ExecutionVertexID> getTasksNeedingRestart(ExecutionVertexID executionVertexId, Throwable cause) {
        return IterableUtils.toStream(this.topology.getVertices()).map(Vertex::getId).collect(Collectors.toSet());
    }

    public static class Factory
    implements FailoverStrategy.Factory {
        @Override
        public FailoverStrategy create(FailoverTopology<?, ?> topology, ResultPartitionAvailabilityChecker resultPartitionAvailabilityChecker) {
            return new RestartAllStrategy(topology);
        }
    }
}

