/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.zookeeper;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.shaded.curator.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.zookeeper.org.apache.zookeeper.data.Stat;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperRunningJobsRegistry
implements RunningJobsRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperRunningJobsRegistry.class);
    private static final Charset ENCODING = Charset.forName("utf-8");
    private final CuratorFramework client;
    private final String runningJobPath;

    public ZooKeeperRunningJobsRegistry(CuratorFramework client, Configuration configuration) {
        this.client = (CuratorFramework)Preconditions.checkNotNull((Object)client, (String)"client");
        this.runningJobPath = configuration.getString(HighAvailabilityOptions.ZOOKEEPER_RUNNING_JOB_REGISTRY_PATH);
    }

    @Override
    public void setJobRunning(JobID jobID) throws IOException {
        Preconditions.checkNotNull((Object)jobID);
        try {
            this.writeEnumToZooKeeper(jobID, RunningJobsRegistry.JobSchedulingStatus.RUNNING);
        }
        catch (Exception e) {
            throw new IOException("Failed to set RUNNING state in ZooKeeper for job " + jobID, e);
        }
    }

    @Override
    public void setJobFinished(JobID jobID) throws IOException {
        Preconditions.checkNotNull((Object)jobID);
        try {
            this.writeEnumToZooKeeper(jobID, RunningJobsRegistry.JobSchedulingStatus.DONE);
        }
        catch (Exception e) {
            throw new IOException("Failed to set DONE state in ZooKeeper for job " + jobID, e);
        }
    }

    @Override
    public RunningJobsRegistry.JobSchedulingStatus getJobSchedulingStatus(JobID jobID) throws IOException {
        Preconditions.checkNotNull((Object)jobID);
        try {
            byte[] data;
            String zkPath = this.createZkPath(jobID);
            Stat stat = (Stat)this.client.checkExists().forPath(zkPath);
            if (stat != null && (data = (byte[])this.client.getData().forPath(zkPath)) != null) {
                try {
                    String name = new String(data, ENCODING);
                    return RunningJobsRegistry.JobSchedulingStatus.valueOf(name);
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("Found corrupt data in ZooKeeper: " + Arrays.toString(data) + " is no valid job status");
                }
            }
            return RunningJobsRegistry.JobSchedulingStatus.PENDING;
        }
        catch (Exception e) {
            throw new IOException("Get finished state from zk fail for job " + jobID.toString(), e);
        }
    }

    @Override
    public void clearJob(JobID jobID) throws IOException {
        Preconditions.checkNotNull((Object)jobID);
        try {
            String zkPath = this.createZkPath(jobID);
            this.client.newNamespaceAwareEnsurePath(zkPath).ensure(this.client.getZookeeperClient());
            this.client.delete().forPath(zkPath);
        }
        catch (Exception e) {
            throw new IOException("Failed to clear job state from ZooKeeper for job " + jobID, e);
        }
    }

    private String createZkPath(JobID jobID) {
        return this.runningJobPath + jobID.toString();
    }

    private void writeEnumToZooKeeper(JobID jobID, RunningJobsRegistry.JobSchedulingStatus status) throws Exception {
        LOG.debug("Setting scheduling state for job {} to {}.", (Object)jobID, (Object)status);
        String zkPath = this.createZkPath(jobID);
        this.client.newNamespaceAwareEnsurePath(zkPath).ensure(this.client.getZookeeperClient());
        this.client.setData().forPath(zkPath, status.name().getBytes(ENCODING));
    }
}

