/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.reporter.InstantiateViaFactory;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.metrics.reporter.MetricReporterFactory;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReporterSetup {
    private static final Logger LOG = LoggerFactory.getLogger(ReporterSetup.class);
    private static final Pattern reporterListPattern = Pattern.compile("\\s*,\\s*");
    private static final Pattern reporterClassPattern = Pattern.compile(Pattern.quote("metrics.reporter.") + "([\\S&&[^.]]*)\\." + '(' + Pattern.quote("class") + '|' + Pattern.quote("factory.class") + ')');
    private final String name;
    private final MetricConfig configuration;
    private final MetricReporter reporter;

    public ReporterSetup(String name, MetricConfig configuration, MetricReporter reporter) {
        this.name = name;
        this.configuration = configuration;
        this.reporter = reporter;
    }

    public Optional<String> getDelimiter() {
        return Optional.ofNullable(this.configuration.getString("scope.delimiter", null));
    }

    public Optional<String> getIntervalSettings() {
        return Optional.ofNullable(this.configuration.getString("interval", null));
    }

    public Set<String> getExcludedVariables() {
        String excludedVariablesList = this.configuration.getString("scope.variables.excludes", null);
        if (excludedVariablesList == null) {
            return Collections.emptySet();
        }
        HashSet<String> excludedVariables = new HashSet<String>();
        for (String exclusion : excludedVariablesList.split(";")) {
            excludedVariables.add(ScopeFormat.asVariable(exclusion));
        }
        return Collections.unmodifiableSet(excludedVariables);
    }

    public String getName() {
        return this.name;
    }

    @VisibleForTesting
    MetricConfig getConfiguration() {
        return this.configuration;
    }

    public MetricReporter getReporter() {
        return this.reporter;
    }

    @VisibleForTesting
    public static ReporterSetup forReporter(String reporterName, MetricReporter reporter) {
        return ReporterSetup.createReporterSetup(reporterName, new MetricConfig(), reporter);
    }

    @VisibleForTesting
    public static ReporterSetup forReporter(String reporterName, MetricConfig metricConfig, MetricReporter reporter) {
        return ReporterSetup.createReporterSetup(reporterName, metricConfig, reporter);
    }

    private static ReporterSetup createReporterSetup(String reporterName, MetricConfig metricConfig, MetricReporter reporter) {
        LOG.info("Configuring {} with {}.", (Object)reporterName, (Object)metricConfig);
        reporter.open(metricConfig);
        return new ReporterSetup(reporterName, metricConfig, reporter);
    }

    public static List<ReporterSetup> fromConfiguration(Configuration configuration) {
        String includedReportersString = configuration.getString(MetricOptions.REPORTERS_LIST, "");
        Set includedReporters = reporterListPattern.splitAsStream(includedReportersString).filter(r -> !r.isEmpty()).collect(Collectors.toSet());
        TreeSet<String> namedReporters = new TreeSet<String>(String::compareTo);
        for (Object key : configuration.keySet()) {
            Matcher matcher;
            if (!((String)key).startsWith("metrics.reporter.") || !(matcher = reporterClassPattern.matcher((CharSequence)key)).matches()) continue;
            String reporterName = matcher.group(1);
            if (includedReporters.isEmpty() || includedReporters.contains(reporterName)) {
                if (namedReporters.contains(reporterName)) {
                    LOG.warn("Duplicate class configuration detected for reporter {}.", (Object)reporterName);
                    continue;
                }
                namedReporters.add(reporterName);
                continue;
            }
            LOG.info("Excluding reporter {}, not configured in reporter list ({}).", (Object)reporterName, (Object)includedReportersString);
        }
        if (namedReporters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Tuple2> reporterConfigurations = new ArrayList<Tuple2>(namedReporters.size());
        for (String namedReporter : namedReporters) {
            DelegatingConfiguration delegatingConfiguration = new DelegatingConfiguration(configuration, "metrics.reporter." + namedReporter + '.');
            reporterConfigurations.add(Tuple2.of((Object)namedReporter, (Object)delegatingConfiguration));
        }
        Map<String, MetricReporterFactory> reporterFactories = ReporterSetup.loadReporterFactories();
        ArrayList<ReporterSetup> reporterArguments = new ArrayList<ReporterSetup>(reporterConfigurations.size());
        for (Tuple2 reporterConfiguration : reporterConfigurations) {
            String reporterName = (String)reporterConfiguration.f0;
            Configuration reporterConfig = (Configuration)reporterConfiguration.f1;
            try {
                Optional<MetricReporter> metricReporterOptional = ReporterSetup.loadReporter(reporterName, reporterConfig, reporterFactories);
                metricReporterOptional.ifPresent(reporter -> {
                    MetricConfig metricConfig = new MetricConfig();
                    reporterConfig.addAllToProperties((Properties)metricConfig);
                    reporterArguments.add(ReporterSetup.createReporterSetup(reporterName, metricConfig, reporter));
                });
            }
            catch (Throwable t) {
                LOG.error("Could not instantiate metrics reporter {}. Metrics might not be exposed/reported.", (Object)reporterName, (Object)t);
            }
        }
        return reporterArguments;
    }

    private static Map<String, MetricReporterFactory> loadReporterFactories() {
        ServiceLoader<MetricReporterFactory> serviceLoader = ServiceLoader.load(MetricReporterFactory.class);
        HashMap<String, MetricReporterFactory> reporterFactories = new HashMap<String, MetricReporterFactory>(2);
        Iterator<MetricReporterFactory> factoryIterator = serviceLoader.iterator();
        while (factoryIterator.hasNext()) {
            try {
                MetricReporterFactory factory = factoryIterator.next();
                reporterFactories.put(factory.getClass().getName(), factory);
            }
            catch (Exception | ServiceConfigurationError e) {
                LOG.warn("Error while loading reporter factory.", e);
            }
        }
        return Collections.unmodifiableMap(reporterFactories);
    }

    private static Optional<MetricReporter> loadReporter(String reporterName, Configuration reporterConfig, Map<String, MetricReporterFactory> reporterFactories) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String reporterClassName = reporterConfig.getString("class", null);
        String factoryClassName = reporterConfig.getString("factory.class", null);
        if (factoryClassName != null) {
            return ReporterSetup.loadViaFactory(factoryClassName, reporterName, reporterConfig, reporterFactories);
        }
        if (reporterClassName != null) {
            return ReporterSetup.loadViaReflection(reporterClassName, reporterName, reporterConfig, reporterFactories);
        }
        LOG.warn("No reporter class nor factory set for reporter {}. Metrics might not be exposed/reported.", (Object)reporterName);
        return Optional.empty();
    }

    private static Optional<MetricReporter> loadViaFactory(String factoryClassName, String reporterName, Configuration reporterConfig, Map<String, MetricReporterFactory> reporterFactories) {
        MetricReporterFactory factory = reporterFactories.get(factoryClassName);
        if (factory == null) {
            LOG.warn("The reporter factory ({}) could not be found for reporter {}. Available factories: {}.", new Object[]{factoryClassName, reporterName, reporterFactories.keySet()});
            return Optional.empty();
        }
        MetricConfig metricConfig = new MetricConfig();
        reporterConfig.addAllToProperties((Properties)metricConfig);
        return Optional.of(factory.createMetricReporter((Properties)metricConfig));
    }

    private static Optional<MetricReporter> loadViaReflection(String reporterClassName, String reporterName, Configuration reporterConfig, Map<String, MetricReporterFactory> reporterFactories) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> reporterClass = Class.forName(reporterClassName);
        InstantiateViaFactory alternativeFactoryAnnotation = reporterClass.getAnnotation(InstantiateViaFactory.class);
        if (alternativeFactoryAnnotation != null) {
            String alternativeFactoryClassName = alternativeFactoryAnnotation.factoryClassName();
            LOG.info("The reporter configuration of {} is out-dated (but still supported). Please configure a factory class instead: '{}{}.{}: {}' to ensure that the configuration continues to work with future versions.", new Object[]{reporterName, "metrics.reporter.", reporterName, "factory.class", alternativeFactoryClassName});
            return ReporterSetup.loadViaFactory(alternativeFactoryClassName, reporterName, reporterConfig, reporterFactories);
        }
        return Optional.of((MetricReporter)reporterClass.newInstance());
    }
}

