/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.rest.FileUploadHandler;
import org.apache.flink.runtime.rest.FlinkHttpObjectAggregator;
import org.apache.flink.runtime.rest.handler.FileUploads;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.InFlightRequestTracker;
import org.apache.flink.runtime.rest.handler.LeaderRetrievalHandler;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.router.RoutedRequest;
import org.apache.flink.runtime.rest.handler.util.HandlerUtils;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.UntypedResponseMessageHeaders;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.guava18.com.google.common.base.Ascii;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParseException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufInputStream;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.FullHttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHandler<T extends RestfulGateway, R extends RequestBody, M extends MessageParameters>
extends LeaderRetrievalHandler<T>
implements AutoCloseableAsync {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final ObjectMapper MAPPER = RestMapperUtils.getStrictObjectMapper();
    private static final int OTHER_RESP_PAYLOAD_OVERHEAD = 1024;
    private final UntypedResponseMessageHeaders<R, M> untypedResponseMessageHeaders;
    private final InFlightRequestTracker inFlightRequestTracker;

    protected AbstractHandler(@Nonnull GatewayRetriever<? extends T> leaderRetriever, @Nonnull Time timeout, @Nonnull Map<String, String> responseHeaders, @Nonnull UntypedResponseMessageHeaders<R, M> untypedResponseMessageHeaders) {
        super(leaderRetriever, timeout, responseHeaders);
        this.untypedResponseMessageHeaders = (UntypedResponseMessageHeaders)Preconditions.checkNotNull(untypedResponseMessageHeaders);
        this.inFlightRequestTracker = new InFlightRequestTracker();
    }

    @Override
    protected void respondAsLeader(ChannelHandlerContext ctx, RoutedRequest routedRequest, T gateway) {
        HttpRequest httpRequest = routedRequest.getRequest();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Received request " + httpRequest.uri() + '.');
        }
        FileUploads uploadedFiles = null;
        try {
            HandlerRequest<RequestBody, M> handlerRequest;
            RequestBody request;
            this.inFlightRequestTracker.registerRequest();
            if (!(httpRequest instanceof FullHttpRequest)) {
                this.log.error("Implementation error: Received a request that wasn't a FullHttpRequest.");
                throw new RestHandlerException("Bad request received.", HttpResponseStatus.BAD_REQUEST);
            }
            ByteBuf msgContent = ((FullHttpRequest)httpRequest).content();
            uploadedFiles = FileUploadHandler.getMultipartFileUploads(ctx);
            if (!this.untypedResponseMessageHeaders.acceptsFileUploads() && !uploadedFiles.getUploadedFiles().isEmpty()) {
                throw new RestHandlerException("File uploads not allowed.", HttpResponseStatus.BAD_REQUEST);
            }
            if (msgContent.capacity() == 0) {
                try {
                    request = (RequestBody)MAPPER.readValue("{}", this.untypedResponseMessageHeaders.getRequestClass());
                }
                catch (JsonParseException | JsonMappingException je) {
                    throw new RestHandlerException("Bad request received. Request did not conform to expected format.", HttpResponseStatus.BAD_REQUEST, je);
                }
            }
            try {
                ByteBufInputStream in = new ByteBufInputStream(msgContent);
                request = (RequestBody)MAPPER.readValue((InputStream)in, this.untypedResponseMessageHeaders.getRequestClass());
            }
            catch (JsonParseException | JsonMappingException je) {
                throw new RestHandlerException(String.format("Request did not match expected format %s.", this.untypedResponseMessageHeaders.getRequestClass().getSimpleName()), HttpResponseStatus.BAD_REQUEST, je);
            }
            try {
                handlerRequest = new HandlerRequest<RequestBody, M>(request, this.untypedResponseMessageHeaders.getUnresolvedMessageParameters(), routedRequest.getRouteResult().pathParams(), routedRequest.getRouteResult().queryParams(), uploadedFiles.getUploadedFiles());
            }
            catch (HandlerRequestException hre) {
                this.log.error("Could not create the handler request.", (Throwable)((Object)hre));
                throw new RestHandlerException(String.format("Bad request, could not parse parameters: %s", hre.getMessage()), HttpResponseStatus.BAD_REQUEST, (Throwable)((Object)hre));
            }
            this.log.trace("Starting request processing.");
            CompletableFuture<Void> requestProcessingFuture = this.respondToRequest(ctx, httpRequest, handlerRequest, gateway);
            FileUploads finalUploadedFiles = uploadedFiles;
            requestProcessingFuture.whenComplete((ignored, throwable) -> {
                if (throwable != null) {
                    this.handleException(ExceptionUtils.stripCompletionException((Throwable)throwable), ctx, httpRequest).whenComplete((ignored2, throwable2) -> this.finalizeRequestProcessing(finalUploadedFiles));
                } else {
                    this.finalizeRequestProcessing(finalUploadedFiles);
                }
            });
        }
        catch (Throwable e) {
            FileUploads finalUploadedFiles = uploadedFiles;
            this.handleException(e, ctx, httpRequest).whenComplete((ignored, throwable) -> this.finalizeRequestProcessing(finalUploadedFiles));
        }
    }

    private void finalizeRequestProcessing(FileUploads uploadedFiles) {
        this.inFlightRequestTracker.deregisterRequest();
        this.cleanupFileUploads(uploadedFiles);
    }

    private CompletableFuture<Void> handleException(Throwable throwable, ChannelHandlerContext ctx, HttpRequest httpRequest) {
        FlinkHttpObjectAggregator flinkHttpObjectAggregator = (FlinkHttpObjectAggregator)ctx.pipeline().get(FlinkHttpObjectAggregator.class);
        int maxLength = flinkHttpObjectAggregator.maxContentLength() - 1024;
        if (throwable instanceof RestHandlerException) {
            RestHandlerException rhe = (RestHandlerException)((Object)throwable);
            String stackTrace = ExceptionUtils.stringifyException((Throwable)((Object)rhe));
            String truncatedStackTrace = Ascii.truncate((CharSequence)stackTrace, (int)maxLength, (String)"...");
            if (this.log.isDebugEnabled()) {
                this.log.error("Exception occurred in REST handler.", (Throwable)((Object)rhe));
            } else {
                this.log.error("Exception occurred in REST handler: {}", (Object)rhe.getMessage());
            }
            return HandlerUtils.sendErrorResponse(ctx, httpRequest, new ErrorResponseBody(truncatedStackTrace), rhe.getHttpResponseStatus(), (Map<String, String>)this.responseHeaders);
        }
        this.log.error("Unhandled exception.", throwable);
        String stackTrace = String.format("<Exception on server side:%n%s%nEnd of exception on server side>", ExceptionUtils.stringifyException((Throwable)throwable));
        String truncatedStackTrace = Ascii.truncate((CharSequence)stackTrace, (int)maxLength, (String)"...");
        return HandlerUtils.sendErrorResponse(ctx, httpRequest, new ErrorResponseBody(Arrays.asList("Internal server error.", truncatedStackTrace)), HttpResponseStatus.INTERNAL_SERVER_ERROR, (Map<String, String>)this.responseHeaders);
    }

    public final CompletableFuture<Void> closeAsync() {
        return FutureUtils.composeAfterwards(this.closeHandlerAsync(), this.inFlightRequestTracker::awaitAsync);
    }

    protected CompletableFuture<Void> closeHandlerAsync() {
        return CompletableFuture.completedFuture(null);
    }

    private void cleanupFileUploads(@Nullable FileUploads uploadedFiles) {
        if (uploadedFiles != null) {
            try {
                uploadedFiles.close();
            }
            catch (IOException e) {
                this.log.warn("Could not cleanup uploaded files.", (Throwable)e);
            }
        }
    }

    protected abstract CompletableFuture<Void> respondToRequest(ChannelHandlerContext var1, HttpRequest var2, HandlerRequest<R, M> var3, T var4) throws RestHandlerException;
}

