/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.RescaleMappings;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.util.IntArrayList;

@Internal
public enum SubtaskStateMapper {
    ARBITRARY{

        @Override
        public int[] getOldSubtasks(int newSubtaskIndex, int oldNumberOfSubtasks, int newNumberOfSubtasks) {
            return ROUND_ROBIN.getOldSubtasks(newSubtaskIndex, oldNumberOfSubtasks, newNumberOfSubtasks);
        }
    }
    ,
    DISCARD_EXTRA_STATE{

        @Override
        public int[] getOldSubtasks(int newSubtaskIndex, int oldNumberOfSubtasks, int newNumberOfSubtasks) {
            int[] nArray;
            if (newSubtaskIndex >= oldNumberOfSubtasks) {
                nArray = EMPTY;
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = newSubtaskIndex;
            }
            return nArray;
        }
    }
    ,
    FIRST{

        @Override
        public int[] getOldSubtasks(int newSubtaskIndex, int oldNumberOfSubtasks, int newNumberOfSubtasks) {
            return newSubtaskIndex == 0 ? IntStream.range(0, oldNumberOfSubtasks).toArray() : EMPTY;
        }
    }
    ,
    FULL{

        @Override
        public int[] getOldSubtasks(int newSubtaskIndex, int oldNumberOfSubtasks, int newNumberOfSubtasks) {
            return IntStream.range(0, oldNumberOfSubtasks).toArray();
        }

        @Override
        public boolean isAmbiguous() {
            return true;
        }
    }
    ,
    RANGE{

        @Override
        public int[] getOldSubtasks(int newSubtaskIndex, int oldNumberOfSubtasks, int newNumberOfSubtasks) {
            int maxParallelism = 32768;
            KeyGroupRange newRange = KeyGroupRangeAssignment.computeKeyGroupRangeForOperatorIndex(maxParallelism, newNumberOfSubtasks, newSubtaskIndex);
            int start2 = KeyGroupRangeAssignment.computeOperatorIndexForKeyGroup(maxParallelism, oldNumberOfSubtasks, newRange.getStartKeyGroup());
            int end = KeyGroupRangeAssignment.computeOperatorIndexForKeyGroup(maxParallelism, oldNumberOfSubtasks, newRange.getEndKeyGroup());
            return IntStream.range(start2, end + 1).toArray();
        }

        @Override
        public boolean isAmbiguous() {
            return true;
        }
    }
    ,
    ROUND_ROBIN{

        @Override
        public int[] getOldSubtasks(int newSubtaskIndex, int oldNumberOfSubtasks, int newNumberOfSubtasks) {
            IntArrayList subtasks = new IntArrayList(oldNumberOfSubtasks / newNumberOfSubtasks + 1);
            for (int subtask = newSubtaskIndex; subtask < oldNumberOfSubtasks; subtask += newNumberOfSubtasks) {
                subtasks.add(subtask);
            }
            return subtasks.toArray();
        }
    }
    ,
    UNSUPPORTED{

        @Override
        public int[] getOldSubtasks(int newSubtaskIndex, int oldNumberOfSubtasks, int newNumberOfSubtasks) {
            throw new UnsupportedOperationException("Cannot rescale the given pointwise partitioner.\nDid you change the partitioner to forward or rescale?\nIt may also help to add an explicit shuffle().");
        }
    };

    private static final int[] EMPTY;

    public abstract int[] getOldSubtasks(int var1, int var2, int var3);

    public RescaleMappings getNewToOldSubtasksMapping(int oldParallelism, int newParallelism) {
        return RescaleMappings.of(IntStream.range(0, newParallelism).mapToObj(channelIndex -> this.getOldSubtasks(channelIndex, oldParallelism, newParallelism)), oldParallelism);
    }

    public boolean isAmbiguous() {
        return false;
    }

    static {
        EMPTY = new int[0];
    }
}

