/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.topology;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.runtime.executiongraph.failover.flip1.PipelinedRegionComputeUtil;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalPipelinedRegion;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalResult;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalVertex;
import org.apache.flink.runtime.jobgraph.topology.LogicalTopology;
import org.apache.flink.util.Preconditions;

public class DefaultLogicalTopology
implements LogicalTopology {
    private final List<DefaultLogicalVertex> verticesSorted;
    private final Map<JobVertexID, DefaultLogicalVertex> idToVertexMap;
    private final Map<IntermediateDataSetID, DefaultLogicalResult> idToResultMap;

    public DefaultLogicalTopology(JobGraph jobGraph) {
        Preconditions.checkNotNull((Object)jobGraph);
        this.verticesSorted = new ArrayList<DefaultLogicalVertex>(jobGraph.getNumberOfVertices());
        this.idToVertexMap = new HashMap<JobVertexID, DefaultLogicalVertex>();
        this.idToResultMap = new HashMap<IntermediateDataSetID, DefaultLogicalResult>();
        this.buildVerticesAndResults(jobGraph);
    }

    private void buildVerticesAndResults(JobGraph jobGraph) {
        Function<JobVertexID, DefaultLogicalVertex> vertexRetriever = this::getVertex;
        Function<IntermediateDataSetID, DefaultLogicalResult> resultRetriever = this::getResult;
        for (JobVertex jobVertex : jobGraph.getVerticesSortedTopologicallyFromSources()) {
            DefaultLogicalVertex logicalVertex = new DefaultLogicalVertex(jobVertex, resultRetriever);
            this.verticesSorted.add(logicalVertex);
            this.idToVertexMap.put(logicalVertex.getId(), logicalVertex);
            for (IntermediateDataSet intermediateDataSet : jobVertex.getProducedDataSets()) {
                DefaultLogicalResult logicalResult = new DefaultLogicalResult(intermediateDataSet, vertexRetriever);
                this.idToResultMap.put(logicalResult.getId(), logicalResult);
            }
        }
    }

    @Override
    public Iterable<DefaultLogicalVertex> getVertices() {
        return this.verticesSorted;
    }

    private DefaultLogicalVertex getVertex(JobVertexID vertexId) {
        return Optional.ofNullable(this.idToVertexMap.get(vertexId)).orElseThrow(() -> new IllegalArgumentException("can not find vertex: " + vertexId));
    }

    private DefaultLogicalResult getResult(IntermediateDataSetID resultId) {
        return Optional.ofNullable(this.idToResultMap.get(resultId)).orElseThrow(() -> new IllegalArgumentException("can not find result: " + resultId));
    }

    public Set<DefaultLogicalPipelinedRegion> getLogicalPipelinedRegions() {
        Set<Set<DefaultLogicalVertex>> regionsRaw = PipelinedRegionComputeUtil.computePipelinedRegions(this.verticesSorted);
        HashSet<DefaultLogicalPipelinedRegion> regions = new HashSet<DefaultLogicalPipelinedRegion>();
        for (Set<DefaultLogicalVertex> regionVertices : regionsRaw) {
            regions.add(new DefaultLogicalPipelinedRegion(regionVertices));
        }
        return regions;
    }
}

