/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateSerializer;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateSerializerImpl;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequest;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestDispatcherImpl;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.CheckpointInProgressRequest;
import org.apache.flink.runtime.checkpoint.channel.CheckpointStartRequest;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.state.ChannelPersistenceITCase;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.util.CloseableIterator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ChannelStateWriteRequestDispatcherTest {
    private final List<ChannelStateWriteRequest> requests;
    private final Optional<Class<?>> expectedException;
    public static final long CHECKPOINT_ID = 42L;

    @Parameterized.Parameters
    public static Object[][] data() {
        return new Object[][]{{Optional.empty(), Arrays.asList(ChannelStateWriteRequestDispatcherTest.start(), ChannelStateWriteRequestDispatcherTest.completeIn(), ChannelStateWriteRequestDispatcherTest.completeOut())}, {Optional.empty(), Arrays.asList(ChannelStateWriteRequestDispatcherTest.start(), ChannelStateWriteRequestDispatcherTest.writeIn(), ChannelStateWriteRequestDispatcherTest.completeIn())}, {Optional.empty(), Arrays.asList(ChannelStateWriteRequestDispatcherTest.start(), ChannelStateWriteRequestDispatcherTest.writeOut(), ChannelStateWriteRequestDispatcherTest.completeOut())}, {Optional.empty(), Arrays.asList(ChannelStateWriteRequestDispatcherTest.start(), ChannelStateWriteRequestDispatcherTest.completeIn(), ChannelStateWriteRequestDispatcherTest.writeOut())}, {Optional.empty(), Arrays.asList(ChannelStateWriteRequestDispatcherTest.start(), ChannelStateWriteRequestDispatcherTest.completeOut(), ChannelStateWriteRequestDispatcherTest.writeIn())}, {Optional.of(IllegalArgumentException.class), Collections.singletonList(ChannelStateWriteRequestDispatcherTest.writeIn())}, {Optional.of(IllegalArgumentException.class), Collections.singletonList(ChannelStateWriteRequestDispatcherTest.writeOut())}, {Optional.of(IllegalArgumentException.class), Collections.singletonList(ChannelStateWriteRequestDispatcherTest.completeIn())}, {Optional.of(IllegalArgumentException.class), Collections.singletonList(ChannelStateWriteRequestDispatcherTest.completeOut())}, {Optional.of(IllegalArgumentException.class), Arrays.asList(ChannelStateWriteRequestDispatcherTest.start(), ChannelStateWriteRequestDispatcherTest.completeIn(), ChannelStateWriteRequestDispatcherTest.completeIn())}, {Optional.of(IllegalArgumentException.class), Arrays.asList(ChannelStateWriteRequestDispatcherTest.start(), ChannelStateWriteRequestDispatcherTest.completeOut(), ChannelStateWriteRequestDispatcherTest.completeOut())}, {Optional.of(IllegalStateException.class), Arrays.asList(ChannelStateWriteRequestDispatcherTest.start(), ChannelStateWriteRequestDispatcherTest.completeIn(), ChannelStateWriteRequestDispatcherTest.writeIn())}, {Optional.of(IllegalStateException.class), Arrays.asList(ChannelStateWriteRequestDispatcherTest.start(), ChannelStateWriteRequestDispatcherTest.completeOut(), ChannelStateWriteRequestDispatcherTest.writeOut())}, {Optional.of(IllegalStateException.class), Arrays.asList(ChannelStateWriteRequestDispatcherTest.start(), ChannelStateWriteRequestDispatcherTest.start())}};
    }

    private static CheckpointInProgressRequest completeOut() {
        return ChannelStateWriteRequest.completeOutput((long)42L);
    }

    private static CheckpointInProgressRequest completeIn() {
        return ChannelStateWriteRequest.completeInput((long)42L);
    }

    private static ChannelStateWriteRequest writeIn() {
        return ChannelStateWriteRequest.write((long)42L, (InputChannelInfo)new InputChannelInfo(1, 1), (CloseableIterator)CloseableIterator.ofElement((Object)new NetworkBuffer(MemorySegmentFactory.allocateUnpooledSegment((int)1), FreeingBufferRecycler.INSTANCE), Buffer::recycleBuffer));
    }

    private static ChannelStateWriteRequest writeOut() {
        return ChannelStateWriteRequest.write((long)42L, (ResultSubpartitionInfo)new ResultSubpartitionInfo(1, 1), (Buffer[])new Buffer[]{new NetworkBuffer(MemorySegmentFactory.allocateUnpooledSegment((int)1), FreeingBufferRecycler.INSTANCE)});
    }

    private static CheckpointStartRequest start() {
        return new CheckpointStartRequest(42L, new ChannelStateWriter.ChannelStateWriteResult(), new CheckpointStorageLocationReference(new byte[]{1}));
    }

    public ChannelStateWriteRequestDispatcherTest(Optional<Class<?>> expectedException, List<ChannelStateWriteRequest> requests) {
        this.requests = requests;
        this.expectedException = expectedException;
    }

    @Test
    public void doRun() {
        ChannelStateWriteRequestDispatcherImpl processor = new ChannelStateWriteRequestDispatcherImpl(0, ChannelPersistenceITCase.getStreamFactoryFactory(), (ChannelStateSerializer)new ChannelStateSerializerImpl());
        try {
            for (ChannelStateWriteRequest request : this.requests) {
                processor.dispatch(request);
            }
        }
        catch (Throwable t) {
            if (this.expectedException.filter(e -> e.isInstance(t)).isPresent()) {
                return;
            }
            throw new RuntimeException("unexpected exception", t);
        }
        this.expectedException.ifPresent(e -> Assert.fail((String)("expected exception " + e)));
    }
}

