/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ApplicationStatusTest
extends TestLogger {
    private static final int SUCCESS_EXIT_CODE = 0;

    @Test
    public void succeededStatusMapsToSuccessExitCode() {
        int exitCode = ApplicationStatus.SUCCEEDED.processExitCode();
        Assert.assertThat((Object)exitCode, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void cancelledStatusMapsToSuccessExitCode() {
        int exitCode = ApplicationStatus.CANCELED.processExitCode();
        Assert.assertThat((Object)exitCode, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void notSucceededNorCancelledStatusMapsToNonSuccessExitCode() {
        Iterable<Integer> exitCodes = ApplicationStatusTest.exitCodes(ApplicationStatusTest.notSucceededNorCancelledStatus());
        Assert.assertThat(exitCodes, (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new Integer[]{0})));
    }

    private static Iterable<Integer> exitCodes(Iterable<ApplicationStatus> statuses) {
        return StreamSupport.stream(statuses.spliterator(), false).map(ApplicationStatus::processExitCode).collect(Collectors.toList());
    }

    private static Iterable<ApplicationStatus> notSucceededNorCancelledStatus() {
        return Arrays.stream(ApplicationStatus.values()).filter(ApplicationStatusTest::isNotSucceededNorCancelled).collect(Collectors.toList());
    }

    private static boolean isNotSucceededNorCancelled(ApplicationStatus status) {
        return status != ApplicationStatus.SUCCEEDED && status != ApplicationStatus.CANCELED;
    }
}

