/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher.runner;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.dispatcher.runner.DispatcherRunner;

public class TestingDispatcherRunner
implements DispatcherRunner {
    private final CompletableFuture<ApplicationStatus> shutDownFuture;
    private final Supplier<CompletableFuture<Void>> closeAsyncSupplier;

    private TestingDispatcherRunner(CompletableFuture<ApplicationStatus> shutDownFuture, Supplier<CompletableFuture<Void>> closeAsyncSupplier) {
        this.shutDownFuture = shutDownFuture;
        this.closeAsyncSupplier = closeAsyncSupplier;
    }

    public CompletableFuture<ApplicationStatus> getShutDownFuture() {
        return this.shutDownFuture;
    }

    public CompletableFuture<Void> closeAsync() {
        return this.closeAsyncSupplier.get();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private CompletableFuture<ApplicationStatus> shutDownFuture = new CompletableFuture();
        private Supplier<CompletableFuture<Void>> closeAsyncSupplier = FutureUtils::completedVoidFuture;

        public Builder setCloseAsyncSupplier(Supplier<CompletableFuture<Void>> closeAsyncSupplier) {
            this.closeAsyncSupplier = closeAsyncSupplier;
            return this;
        }

        public Builder setShutDownFuture(CompletableFuture<ApplicationStatus> shutDownFuture) {
            this.shutDownFuture = shutDownFuture;
            return this;
        }

        public TestingDispatcherRunner build() {
            return new TestingDispatcherRunner(this.shutDownFuture, this.closeAsyncSupplier);
        }
    }
}

