/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BufferPoolFactoryTest {
    private static final int numBuffers = 1024;
    private static final int memorySegmentSize = 128;
    private NetworkBufferPool networkBufferPool;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setupNetworkBufferPool() {
        this.networkBufferPool = new NetworkBufferPool(1024, 128);
    }

    @After
    public void verifyAllBuffersReturned() {
        String msg = "Did not return all buffers to network buffer pool after test.";
        try {
            Assert.assertEquals((String)msg, (long)1024L, (long)this.networkBufferPool.getNumberOfAvailableMemorySegments());
        }
        finally {
            this.networkBufferPool.destroyAllBufferPools();
            this.networkBufferPool.destroy();
        }
    }

    @Test
    public void testRequireMoreThanPossible1() throws IOException {
        this.expectedException.expect(IOException.class);
        this.expectedException.expectMessage("Insufficient number of network buffers");
        this.networkBufferPool.createBufferPool(this.networkBufferPool.getTotalNumberOfMemorySegments() + 1, Integer.MAX_VALUE);
    }

    @Test
    public void testRequireMoreThanPossible2() throws IOException {
        this.expectedException.expect(IOException.class);
        this.expectedException.expectMessage("Insufficient number of network buffers");
        BufferPool bufferPool = null;
        try {
            bufferPool = this.networkBufferPool.createBufferPool(513, 1024);
            this.networkBufferPool.createBufferPool(513, 1024);
        }
        finally {
            if (bufferPool != null) {
                bufferPool.lazyDestroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOverprovisioned() throws IOException {
        int buffersToTakeFromPool1 = 513;
        int buffersToTakeFromPool2 = 1024 - buffersToTakeFromPool1;
        ArrayList<Buffer> buffers = new ArrayList<Buffer>(1024);
        BufferPool bufferPool1 = null;
        BufferPool bufferPool2 = null;
        try {
            Buffer buffer;
            int i;
            bufferPool1 = this.networkBufferPool.createBufferPool(buffersToTakeFromPool2, 1024);
            for (i = 0; i < buffersToTakeFromPool1; ++i) {
                buffer = bufferPool1.requestBuffer();
                Assert.assertNotNull((Object)buffer);
                buffers.add(buffer);
            }
            Assert.assertEquals((long)buffersToTakeFromPool1, (long)bufferPool1.bestEffortGetNumOfUsedBuffers());
            Assert.assertEquals((long)1024L, (long)bufferPool1.getNumBuffers());
            bufferPool2 = this.networkBufferPool.createBufferPool(buffersToTakeFromPool1, 1024);
            Assert.assertEquals((long)bufferPool2.getNumberOfRequiredMemorySegments(), (long)bufferPool2.getNumBuffers());
            Assert.assertEquals((long)bufferPool1.getNumberOfRequiredMemorySegments(), (long)bufferPool1.getNumBuffers());
            Assert.assertNull((Object)bufferPool1.requestBuffer());
            for (i = 0; i < buffersToTakeFromPool2; ++i) {
                buffer = bufferPool2.requestBuffer();
                Assert.assertNotNull((Object)buffer);
                buffers.add(buffer);
            }
            Assert.assertEquals((long)buffersToTakeFromPool2, (long)bufferPool2.bestEffortGetNumOfUsedBuffers());
            Assert.assertNull((Object)bufferPool2.requestBuffer());
            ((Buffer)buffers.remove(0)).recycleBuffer();
            Assert.assertEquals((long)0L, (long)this.networkBufferPool.getNumberOfAvailableMemorySegments());
            Assert.assertEquals((long)(buffersToTakeFromPool1 - 1), (long)(bufferPool1.bestEffortGetNumOfUsedBuffers() + bufferPool1.getNumberOfAvailableMemorySegments()));
            Assert.assertEquals((long)(buffersToTakeFromPool2 + 1), (long)(bufferPool2.bestEffortGetNumOfUsedBuffers() + bufferPool2.getNumberOfAvailableMemorySegments()));
        }
        finally {
            for (Buffer buffer : buffers) {
                buffer.recycleBuffer();
            }
            if (bufferPool1 != null) {
                bufferPool1.lazyDestroy();
            }
            if (bufferPool2 != null) {
                bufferPool2.lazyDestroy();
            }
        }
    }

    @Test
    public void testBoundedPools() throws IOException {
        BufferPool bufferPool1 = this.networkBufferPool.createBufferPool(1, 1);
        Assert.assertEquals((long)1L, (long)bufferPool1.getNumBuffers());
        BufferPool bufferPool2 = this.networkBufferPool.createBufferPool(1, 2);
        Assert.assertEquals((long)2L, (long)bufferPool2.getNumBuffers());
        bufferPool1.lazyDestroy();
        bufferPool2.lazyDestroy();
    }

    @Test
    public void testSingleManagedPoolGetsAll() throws IOException {
        BufferPool bufferPool = this.networkBufferPool.createBufferPool(1, Integer.MAX_VALUE);
        Assert.assertEquals((long)this.networkBufferPool.getTotalNumberOfMemorySegments(), (long)bufferPool.getNumBuffers());
        bufferPool.lazyDestroy();
    }

    @Test
    public void testSingleManagedPoolGetsAllExceptFixedOnes() throws IOException {
        BufferPool fixedBufferPool = this.networkBufferPool.createBufferPool(24, 24);
        BufferPool flexibleBufferPool = this.networkBufferPool.createBufferPool(1, Integer.MAX_VALUE);
        Assert.assertEquals((long)24L, (long)fixedBufferPool.getNumBuffers());
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() - fixedBufferPool.getNumBuffers()), (long)flexibleBufferPool.getNumBuffers());
        fixedBufferPool.lazyDestroy();
        flexibleBufferPool.lazyDestroy();
    }

    @Test
    public void testUniformDistribution() throws IOException {
        BufferPool first = this.networkBufferPool.createBufferPool(1, Integer.MAX_VALUE);
        Assert.assertEquals((long)this.networkBufferPool.getTotalNumberOfMemorySegments(), (long)first.getNumBuffers());
        BufferPool second = this.networkBufferPool.createBufferPool(1, Integer.MAX_VALUE);
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)first.getNumBuffers());
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)second.getNumBuffers());
        first.lazyDestroy();
        second.lazyDestroy();
    }

    @Test
    public void testUniformDistributionAllBuffers() throws IOException {
        BufferPool first = this.networkBufferPool.createBufferPool(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2, Integer.MAX_VALUE);
        Assert.assertEquals((long)this.networkBufferPool.getTotalNumberOfMemorySegments(), (long)first.getNumBuffers());
        BufferPool second = this.networkBufferPool.createBufferPool(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2, Integer.MAX_VALUE);
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)first.getNumBuffers());
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)second.getNumBuffers());
        first.lazyDestroy();
        second.lazyDestroy();
    }

    @Test
    public void testUniformDistributionBounded1() throws IOException {
        BufferPool first = this.networkBufferPool.createBufferPool(1, this.networkBufferPool.getTotalNumberOfMemorySegments());
        Assert.assertEquals((long)this.networkBufferPool.getTotalNumberOfMemorySegments(), (long)first.getNumBuffers());
        BufferPool second = this.networkBufferPool.createBufferPool(1, this.networkBufferPool.getTotalNumberOfMemorySegments());
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)first.getNumBuffers());
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)second.getNumBuffers());
        first.lazyDestroy();
        second.lazyDestroy();
    }

    @Test
    public void testUniformDistributionBounded2() throws IOException {
        BufferPool first = this.networkBufferPool.createBufferPool(1, 10);
        Assert.assertEquals((long)10L, (long)first.getNumBuffers());
        BufferPool second = this.networkBufferPool.createBufferPool(1, 10);
        Assert.assertEquals((long)10L, (long)first.getNumBuffers());
        Assert.assertEquals((long)10L, (long)second.getNumBuffers());
        first.lazyDestroy();
        second.lazyDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUniformDistributionBounded3() throws IOException {
        NetworkBufferPool globalPool = new NetworkBufferPool(3, 128);
        try {
            BufferPool first = globalPool.createBufferPool(1, 10);
            Assert.assertEquals((long)3L, (long)first.getNumBuffers());
            BufferPool second = globalPool.createBufferPool(1, 10);
            Assert.assertEquals((long)3L, (long)(first.getNumBuffers() + second.getNumBuffers()));
            Assert.assertNotEquals((long)3L, (long)first.getNumBuffers());
            Assert.assertNotEquals((long)3L, (long)second.getNumBuffers());
            BufferPool third = globalPool.createBufferPool(1, 10);
            Assert.assertEquals((long)1L, (long)first.getNumBuffers());
            Assert.assertEquals((long)1L, (long)second.getNumBuffers());
            Assert.assertEquals((long)1L, (long)third.getNumBuffers());
            String msg = "Wrong number of available segments after creating buffer pools.";
            Assert.assertEquals((String)msg, (long)0L, (long)globalPool.getNumberOfAvailableMemorySegments());
        }
        finally {
            globalPool.destroyAllBufferPools();
            globalPool.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUniformDistributionBounded4() throws IOException {
        NetworkBufferPool globalPool = new NetworkBufferPool(10, 128);
        try {
            BufferPool first = globalPool.createBufferPool(1, 10);
            Assert.assertEquals((long)10L, (long)first.getNumBuffers());
            List segmentList1 = globalPool.requestMemorySegments(2);
            Assert.assertEquals((long)2L, (long)segmentList1.size());
            Assert.assertEquals((long)8L, (long)first.getNumBuffers());
            BufferPool second = globalPool.createBufferPool(1, 10);
            Assert.assertEquals((long)4L, (long)first.getNumBuffers());
            Assert.assertEquals((long)4L, (long)second.getNumBuffers());
            List segmentList2 = globalPool.requestMemorySegments(2);
            Assert.assertEquals((long)2L, (long)segmentList2.size());
            Assert.assertEquals((long)3L, (long)first.getNumBuffers());
            Assert.assertEquals((long)3L, (long)second.getNumBuffers());
            List segmentList3 = globalPool.requestMemorySegments(2);
            Assert.assertEquals((long)2L, (long)segmentList3.size());
            Assert.assertEquals((long)2L, (long)first.getNumBuffers());
            Assert.assertEquals((long)2L, (long)second.getNumBuffers());
            String msg = "Wrong number of available segments after creating buffer pools and requesting segments.";
            Assert.assertEquals((String)msg, (long)2L, (long)globalPool.getNumberOfAvailableMemorySegments());
            globalPool.recycleMemorySegments((Collection)segmentList1);
            Assert.assertEquals((String)msg, (long)4L, (long)globalPool.getNumberOfAvailableMemorySegments());
            Assert.assertEquals((long)3L, (long)first.getNumBuffers());
            Assert.assertEquals((long)3L, (long)second.getNumBuffers());
            globalPool.recycleMemorySegments((Collection)segmentList2);
            Assert.assertEquals((String)msg, (long)6L, (long)globalPool.getNumberOfAvailableMemorySegments());
            Assert.assertEquals((long)4L, (long)first.getNumBuffers());
            Assert.assertEquals((long)4L, (long)second.getNumBuffers());
            globalPool.recycleMemorySegments((Collection)segmentList3);
            Assert.assertEquals((String)msg, (long)8L, (long)globalPool.getNumberOfAvailableMemorySegments());
            Assert.assertEquals((long)5L, (long)first.getNumBuffers());
            Assert.assertEquals((long)5L, (long)second.getNumBuffers());
            first.lazyDestroy();
            Assert.assertEquals((String)msg, (long)9L, (long)globalPool.getNumberOfAvailableMemorySegments());
            Assert.assertEquals((long)10L, (long)second.getNumBuffers());
        }
        finally {
            globalPool.destroyAllBufferPools();
            globalPool.destroy();
        }
    }

    @Test
    public void testBufferRedistributionMixed1() throws IOException {
        for (int i = 0; i < 1000; ++i) {
            BufferPool first = this.networkBufferPool.createBufferPool(1, 10);
            Assert.assertEquals((long)10L, (long)first.getNumBuffers());
            BufferPool second = this.networkBufferPool.createBufferPool(1, 10);
            Assert.assertEquals((long)10L, (long)first.getNumBuffers());
            Assert.assertEquals((long)10L, (long)second.getNumBuffers());
            BufferPool third = this.networkBufferPool.createBufferPool(1, Integer.MAX_VALUE);
            for (BufferPool bp : new BufferPool[]{first, second, third}) {
                int avail = 1021;
                int size = 1021 * Math.min(1021, bp.getMaxNumberOfMemorySegments() - 1) / 1039 + 1;
                Assert.assertThat((String)"Wrong buffer pool size after redistribution", (Object)bp.getNumBuffers(), (Matcher)Matchers.isOneOf((Object[])new Integer[]{size, size + 1}));
            }
            BufferPool fourth = this.networkBufferPool.createBufferPool(1, Integer.MAX_VALUE);
            for (BufferPool bp : new BufferPool[]{first, second, third, fourth}) {
                int avail = 1020;
                int size = 1020 * Math.min(1020, bp.getMaxNumberOfMemorySegments() - 1) / 2058 + 1;
                Assert.assertThat((String)"Wrong buffer pool size after redistribution", (Object)bp.getNumBuffers(), (Matcher)Matchers.isOneOf((Object[])new Integer[]{size, size + 1}));
            }
            Stream.of(first, second, third, fourth).forEach(BufferPool::lazyDestroy);
            this.verifyAllBuffersReturned();
            this.setupNetworkBufferPool();
        }
    }

    @Test
    public void testAllDistributed() throws IOException {
        for (int i = 0; i < 1000; ++i) {
            Random random = new Random();
            ArrayList<BufferPool> pools = new ArrayList<BufferPool>();
            int numPools = 32;
            long maxTotalUsed = 0L;
            for (int j = 0; j < numPools; ++j) {
                int numRequiredBuffers = random.nextInt(7) + 1;
                int maxUsedBuffers = random.nextBoolean() ? Integer.MAX_VALUE : Math.max(1, random.nextInt(10) + numRequiredBuffers);
                pools.add(this.networkBufferPool.createBufferPool(numRequiredBuffers, maxUsedBuffers));
                maxTotalUsed = Math.min(1024L, maxTotalUsed + (long)maxUsedBuffers);
                int numDistributedBuffers = 0;
                for (BufferPool pool : pools) {
                    numDistributedBuffers += pool.getNumBuffers();
                }
                Assert.assertEquals((long)maxTotalUsed, (long)numDistributedBuffers);
            }
            pools.forEach(BufferPool::lazyDestroy);
            this.verifyAllBuffersReturned();
            this.setupNetworkBufferPool();
        }
    }

    @Test
    public void testCreateDestroy() throws IOException {
        BufferPool first = this.networkBufferPool.createBufferPool(1, Integer.MAX_VALUE);
        Assert.assertEquals((long)this.networkBufferPool.getTotalNumberOfMemorySegments(), (long)first.getNumBuffers());
        BufferPool second = this.networkBufferPool.createBufferPool(1, Integer.MAX_VALUE);
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)first.getNumBuffers());
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)second.getNumBuffers());
        first.lazyDestroy();
        Assert.assertEquals((long)this.networkBufferPool.getTotalNumberOfMemorySegments(), (long)second.getNumBuffers());
        second.lazyDestroy();
    }
}

