/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.shaded.netty4.io.netty.util.ResourceLeakDetector;
import org.apache.flink.shaded.netty4.io.netty.util.ResourceLeakDetectorFactory;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.slf4j.LoggerFactory;

public class NettyLeakDetectionResource
extends ExternalResource {
    @GuardedBy(value="refCountLock")
    private static ResourceLeakDetectorFactory previousLeakDetector;
    @GuardedBy(value="refCountLock")
    private static ResourceLeakDetector.Level previousLeakDetectorLevel;
    private static final Object refCountLock;
    private static int refCount;

    public NettyLeakDetectionResource() {
        Assert.assertTrue((String)"Error logging must be enabled for the ResourceLeakDetector.", (boolean)LoggerFactory.getLogger(ResourceLeakDetector.class).isErrorEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void before() {
        Object object = refCountLock;
        synchronized (object) {
            if (refCount == 0) {
                previousLeakDetector = ResourceLeakDetectorFactory.instance();
                previousLeakDetectorLevel = ResourceLeakDetector.getLevel();
                ++refCount;
                ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.PARANOID);
                ResourceLeakDetectorFactory.setResourceLeakDetectorFactory((ResourceLeakDetectorFactory)new FailingResourceLeakDetectorFactory());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void after() {
        Object object = refCountLock;
        synchronized (object) {
            if (--refCount == 0) {
                ResourceLeakDetectorFactory.setResourceLeakDetectorFactory((ResourceLeakDetectorFactory)previousLeakDetector);
                ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)previousLeakDetectorLevel);
            }
        }
    }

    static {
        refCountLock = new Object();
        refCount = 0;
    }

    private static class FailingResourceLeakDetector<T>
    extends ResourceLeakDetector<T> {
        FailingResourceLeakDetector(Class<?> resourceType, int samplingInterval, long maxActive) {
            super(resourceType, samplingInterval, maxActive);
        }

        protected void reportTracedLeak(String resourceType, String records) {
            super.reportTracedLeak(resourceType, records);
            Assert.fail((String)String.format("LEAK: %s.release() was not called before it's garbage-collected.%s", resourceType, records));
        }

        protected void reportUntracedLeak(String resourceType) {
            super.reportUntracedLeak(resourceType);
            Assert.fail((String)String.format("LEAK: %s.release() was not called before it's garbage-collected.", resourceType));
        }
    }

    private static class FailingResourceLeakDetectorFactory
    extends ResourceLeakDetectorFactory {
        private FailingResourceLeakDetectorFactory() {
        }

        public <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> resource, int samplingInterval, long maxActive) {
            return new FailingResourceLeakDetector(resource, samplingInterval, maxActive);
        }
    }
}

