/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.flink.runtime.util.ResettableMutableObjectIterator;

public class CollectionIterator<T>
implements ResettableMutableObjectIterator<T> {
    private final Collection<T> collection;
    private Iterator<T> iterator;

    public CollectionIterator(Collection<T> collection) {
        this.collection = collection;
        this.iterator = collection.iterator();
    }

    public T next(T reuse) throws IOException {
        return this.next();
    }

    public T next() throws IOException {
        if (!this.iterator.hasNext()) {
            return null;
        }
        return this.iterator.next();
    }

    public void reset() throws IOException {
        this.iterator = this.collection.iterator();
    }

    public static <T> CollectionIterator<T> of(T ... values) {
        return new CollectionIterator<T>(Arrays.asList(values));
    }
}

