/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.rest.HttpMethodWrapper;
import org.apache.flink.runtime.rest.handler.AbstractHandler;
import org.apache.flink.runtime.rest.handler.FileUploads;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.router.RouteResult;
import org.apache.flink.runtime.rest.handler.router.RoutedRequest;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.UntypedResponseMessageHeaders;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMethod;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.shaded.netty4.io.netty.util.Attribute;
import org.apache.flink.shaded.netty4.io.netty.util.AttributeKey;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class AbstractHandlerTest
extends TestLogger {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testFileCleanup() throws Exception {
        Path dir = this.temporaryFolder.newFolder().toPath();
        Path file = dir.resolve("file");
        Files.createFile(file, new FileAttribute[0]);
        TestingRestfulGateway mockRestfulGateway = new TestingRestfulGateway.Builder().build();
        GatewayRetriever mockGatewayRetriever = () -> CompletableFuture.completedFuture(mockRestfulGateway);
        CompletableFuture<Void> requestProcessingCompleteFuture = new CompletableFuture<Void>();
        TestHandler handler = new TestHandler(requestProcessingCompleteFuture, (GatewayRetriever<? extends RestfulGateway>)mockGatewayRetriever);
        RouteResult routeResult = new RouteResult("", "", Collections.emptyMap(), Collections.emptyMap(), (Object)"");
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, TestHandler.TestHeaders.INSTANCE.getTargetRestEndpointURL(), Unpooled.wrappedBuffer((byte[])new byte[0]));
        RoutedRequest routerRequest = new RoutedRequest(routeResult, (HttpRequest)request);
        SimpleAttribute attribute = new SimpleAttribute();
        attribute.set(new FileUploads(dir));
        Channel channel = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)channel.attr((AttributeKey)Matchers.any(AttributeKey.class))).thenReturn((Object)attribute);
        ChannelHandlerContext context = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)context.channel()).thenReturn((Object)channel);
        handler.respondAsLeader(context, routerRequest, mockRestfulGateway);
        Assert.assertTrue((boolean)Files.exists(file, new LinkOption[0]));
        requestProcessingCompleteFuture.complete(null);
        Assert.assertFalse((boolean)Files.exists(file, new LinkOption[0]));
    }

    private static class TestHandler
    extends AbstractHandler<RestfulGateway, EmptyRequestBody, EmptyMessageParameters> {
        private final CompletableFuture<Void> completionFuture;

        protected TestHandler(CompletableFuture<Void> completionFuture, @Nonnull GatewayRetriever<? extends RestfulGateway> leaderRetriever) {
            super(leaderRetriever, RpcUtils.INF_TIMEOUT, Collections.emptyMap(), (UntypedResponseMessageHeaders)TestHeaders.INSTANCE);
            this.completionFuture = completionFuture;
        }

        protected CompletableFuture<Void> respondToRequest(ChannelHandlerContext ctx, HttpRequest httpRequest, HandlerRequest<EmptyRequestBody, EmptyMessageParameters> handlerRequest, RestfulGateway gateway) throws RestHandlerException {
            return this.completionFuture;
        }

        private static enum TestHeaders implements UntypedResponseMessageHeaders<EmptyRequestBody, EmptyMessageParameters>
        {
            INSTANCE;


            public Class<EmptyRequestBody> getRequestClass() {
                return EmptyRequestBody.class;
            }

            public EmptyMessageParameters getUnresolvedMessageParameters() {
                return EmptyMessageParameters.getInstance();
            }

            public HttpMethodWrapper getHttpMethod() {
                return HttpMethodWrapper.POST;
            }

            public String getTargetRestEndpointURL() {
                return "/test";
            }

            public boolean acceptsFileUploads() {
                return true;
            }
        }
    }

    private static class SimpleAttribute
    implements Attribute<FileUploads> {
        private static final AttributeKey<FileUploads> KEY = AttributeKey.valueOf((String)"test");
        private final AtomicReference<FileUploads> container = new AtomicReference();

        private SimpleAttribute() {
        }

        public AttributeKey<FileUploads> key() {
            return KEY;
        }

        public FileUploads get() {
            return this.container.get();
        }

        public void set(FileUploads value) {
            this.container.set(value);
        }

        public FileUploads getAndSet(FileUploads value) {
            return this.container.getAndSet(value);
        }

        public FileUploads setIfAbsent(FileUploads value) {
            if (this.container.compareAndSet(null, value)) {
                return value;
            }
            return this.container.get();
        }

        public FileUploads getAndRemove() {
            return this.container.getAndSet(null);
        }

        public boolean compareAndSet(FileUploads oldValue, FileUploads newValue) {
            return this.container.compareAndSet(oldValue, newValue);
        }

        public void remove() {
            this.set(null);
        }
    }
}

