/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.metrics.dump.MetricDump;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.metrics.AbstractAggregatingMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcherImpl;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.metrics.AbstractAggregatedMetricsParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedMetric;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedMetricsResponseBody;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceRetriever;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.powermock.api.mockito.PowerMockito;

public abstract class AggregatingMetricsHandlerTestBase<H extends AbstractAggregatingMetricsHandler<P>, P extends AbstractAggregatedMetricsParameters<?>>
extends TestLogger {
    private static final CompletableFuture<String> TEST_REST_ADDRESS;
    private static final DispatcherGateway MOCK_DISPATCHER_GATEWAY;
    private static final GatewayRetriever<DispatcherGateway> LEADER_RETRIEVER;
    private static final Time TIMEOUT;
    private static final Map<String, String> TEST_HEADERS;
    private static final Executor EXECUTOR;
    private H handler;
    private MetricStore store;
    private Map<String, String> pathParameters;

    @Before
    public void setUp() throws Exception {
        MetricFetcherImpl fetcher = new MetricFetcherImpl((GatewayRetriever)PowerMockito.mock(GatewayRetriever.class), (MetricQueryServiceRetriever)PowerMockito.mock(MetricQueryServiceRetriever.class), Executors.directExecutor(), TestingUtils.TIMEOUT(), ((Long)MetricOptions.METRIC_FETCHER_UPDATE_INTERVAL.defaultValue()).longValue());
        this.store = fetcher.getMetricStore();
        Collection<MetricDump> metricDumps = this.getMetricDumps();
        for (MetricDump dump : metricDumps) {
            this.store.add(dump);
        }
        this.handler = this.getHandler(LEADER_RETRIEVER, TIMEOUT, TEST_HEADERS, EXECUTOR, (MetricFetcher)fetcher);
        this.pathParameters = this.getPathParameters();
    }

    protected Map<String, String> getPathParameters() {
        return Collections.emptyMap();
    }

    protected abstract Tuple2<String, List<String>> getFilter();

    protected abstract Collection<MetricDump> getMetricDumps();

    protected abstract H getHandler(GatewayRetriever<? extends RestfulGateway> var1, Time var2, Map<String, String> var3, Executor var4, MetricFetcher var5);

    @Test
    public void getStores() throws Exception {
        HandlerRequest request = new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), this.handler.getMessageHeaders().getUnresolvedMessageParameters(), this.pathParameters, Collections.emptyMap());
        Collection subStores = this.handler.getStores(this.store, request);
        Assert.assertEquals((long)3L, (long)subStores.size());
        List sortedMetrics1 = subStores.stream().map(subStore -> subStore.getMetric("abc.metric1")).filter(Objects::nonNull).sorted().collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)sortedMetrics1.size());
        Assert.assertEquals((Object)"1", sortedMetrics1.get(0));
        Assert.assertEquals((Object)"3", sortedMetrics1.get(1));
        List sortedMetrics2 = subStores.stream().map(subStore -> subStore.getMetric("abc.metric2")).filter(Objects::nonNull).sorted().collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)sortedMetrics2.size());
        Assert.assertEquals((Object)"5", sortedMetrics2.get(0));
        Tuple2<String, List<String>> filter = this.getFilter();
        HashMap<Object, Object> queryParameters = new HashMap<Object, Object>(4);
        queryParameters.put(filter.f0, filter.f1);
        HandlerRequest request2 = new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), this.handler.getMessageHeaders().getUnresolvedMessageParameters(), this.pathParameters, queryParameters);
        Collection subStores2 = this.handler.getStores(this.store, request2);
        Assert.assertEquals((long)2L, (long)subStores2.size());
        List sortedMetrics12 = subStores2.stream().map(subStore -> subStore.getMetric("abc.metric1")).filter(Objects::nonNull).sorted().collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)sortedMetrics12.size());
        Assert.assertEquals((Object)"1", sortedMetrics12.get(0));
        List sortedMetrics22 = subStores2.stream().map(subStore -> subStore.getMetric("abc.metric2")).filter(Objects::nonNull).sorted().collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)sortedMetrics22.size());
        Assert.assertEquals((Object)"5", sortedMetrics22.get(0));
    }

    @Test
    public void testListMetrics() throws Exception {
        HandlerRequest request = new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), this.handler.getMessageHeaders().getUnresolvedMessageParameters(), this.pathParameters, Collections.emptyMap());
        AggregatedMetricsResponseBody response = (AggregatedMetricsResponseBody)this.handler.handleRequest(request, (RestfulGateway)MOCK_DISPATCHER_GATEWAY).get();
        List availableMetrics = response.getMetrics().stream().map(AggregatedMetric::getId).sorted().collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)availableMetrics.size());
        Assert.assertEquals((Object)"abc.metric1", availableMetrics.get(0));
        Assert.assertEquals((Object)"abc.metric2", availableMetrics.get(1));
    }

    @Test
    public void testMinAggregation() throws Exception {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>(4);
        queryParams.put("get", Collections.singletonList("abc.metric1"));
        queryParams.put("agg", Collections.singletonList("min"));
        HandlerRequest request = new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), this.handler.getMessageHeaders().getUnresolvedMessageParameters(), this.pathParameters, queryParams);
        AggregatedMetricsResponseBody response = (AggregatedMetricsResponseBody)this.handler.handleRequest(request, (RestfulGateway)MOCK_DISPATCHER_GATEWAY).get();
        Collection aggregatedMetrics = response.getMetrics();
        Assert.assertEquals((long)1L, (long)aggregatedMetrics.size());
        AggregatedMetric aggregatedMetric = (AggregatedMetric)aggregatedMetrics.iterator().next();
        Assert.assertEquals((Object)"abc.metric1", (Object)aggregatedMetric.getId());
        Assert.assertEquals((double)1.0, (double)aggregatedMetric.getMin(), (double)0.1);
        Assert.assertNull((Object)aggregatedMetric.getMax());
        Assert.assertNull((Object)aggregatedMetric.getSum());
        Assert.assertNull((Object)aggregatedMetric.getAvg());
    }

    @Test
    public void testMaxAggregation() throws Exception {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>(4);
        queryParams.put("get", Collections.singletonList("abc.metric1"));
        queryParams.put("agg", Collections.singletonList("max"));
        HandlerRequest request = new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), this.handler.getMessageHeaders().getUnresolvedMessageParameters(), this.pathParameters, queryParams);
        AggregatedMetricsResponseBody response = (AggregatedMetricsResponseBody)this.handler.handleRequest(request, (RestfulGateway)MOCK_DISPATCHER_GATEWAY).get();
        Collection aggregatedMetrics = response.getMetrics();
        Assert.assertEquals((long)1L, (long)aggregatedMetrics.size());
        AggregatedMetric aggregatedMetric = (AggregatedMetric)aggregatedMetrics.iterator().next();
        Assert.assertEquals((Object)"abc.metric1", (Object)aggregatedMetric.getId());
        Assert.assertEquals((double)3.0, (double)aggregatedMetric.getMax(), (double)0.1);
        Assert.assertNull((Object)aggregatedMetric.getMin());
        Assert.assertNull((Object)aggregatedMetric.getSum());
        Assert.assertNull((Object)aggregatedMetric.getAvg());
    }

    @Test
    public void testSumAggregation() throws Exception {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>(4);
        queryParams.put("get", Collections.singletonList("abc.metric1"));
        queryParams.put("agg", Collections.singletonList("sum"));
        HandlerRequest request = new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), this.handler.getMessageHeaders().getUnresolvedMessageParameters(), this.pathParameters, queryParams);
        AggregatedMetricsResponseBody response = (AggregatedMetricsResponseBody)this.handler.handleRequest(request, (RestfulGateway)MOCK_DISPATCHER_GATEWAY).get();
        Collection aggregatedMetrics = response.getMetrics();
        Assert.assertEquals((long)1L, (long)aggregatedMetrics.size());
        AggregatedMetric aggregatedMetric = (AggregatedMetric)aggregatedMetrics.iterator().next();
        Assert.assertEquals((Object)"abc.metric1", (Object)aggregatedMetric.getId());
        Assert.assertEquals((double)4.0, (double)aggregatedMetric.getSum(), (double)0.1);
        Assert.assertNull((Object)aggregatedMetric.getMin());
        Assert.assertNull((Object)aggregatedMetric.getMax());
        Assert.assertNull((Object)aggregatedMetric.getAvg());
    }

    @Test
    public void testAvgAggregation() throws Exception {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>(4);
        queryParams.put("get", Collections.singletonList("abc.metric1"));
        queryParams.put("agg", Collections.singletonList("avg"));
        HandlerRequest request = new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), this.handler.getMessageHeaders().getUnresolvedMessageParameters(), this.pathParameters, queryParams);
        AggregatedMetricsResponseBody response = (AggregatedMetricsResponseBody)this.handler.handleRequest(request, (RestfulGateway)MOCK_DISPATCHER_GATEWAY).get();
        Collection aggregatedMetrics = response.getMetrics();
        Assert.assertEquals((long)1L, (long)aggregatedMetrics.size());
        AggregatedMetric aggregatedMetric = (AggregatedMetric)aggregatedMetrics.iterator().next();
        Assert.assertEquals((Object)"abc.metric1", (Object)aggregatedMetric.getId());
        Assert.assertEquals((double)2.0, (double)aggregatedMetric.getAvg(), (double)0.1);
        Assert.assertNull((Object)aggregatedMetric.getMin());
        Assert.assertNull((Object)aggregatedMetric.getMax());
        Assert.assertNull((Object)aggregatedMetric.getSum());
    }

    @Test
    public void testMultipleAggregation() throws Exception {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>(4);
        queryParams.put("get", Collections.singletonList("abc.metric1"));
        queryParams.put("agg", Arrays.asList("min", "max", "avg"));
        HandlerRequest request = new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), this.handler.getMessageHeaders().getUnresolvedMessageParameters(), this.pathParameters, queryParams);
        AggregatedMetricsResponseBody response = (AggregatedMetricsResponseBody)this.handler.handleRequest(request, (RestfulGateway)MOCK_DISPATCHER_GATEWAY).get();
        Collection aggregatedMetrics = response.getMetrics();
        Assert.assertEquals((long)1L, (long)aggregatedMetrics.size());
        AggregatedMetric aggregatedMetric = (AggregatedMetric)aggregatedMetrics.iterator().next();
        Assert.assertEquals((Object)"abc.metric1", (Object)aggregatedMetric.getId());
        Assert.assertEquals((double)1.0, (double)aggregatedMetric.getMin(), (double)0.1);
        Assert.assertEquals((double)3.0, (double)aggregatedMetric.getMax(), (double)0.1);
        Assert.assertEquals((double)2.0, (double)aggregatedMetric.getAvg(), (double)0.1);
        Assert.assertNull((Object)aggregatedMetric.getSum());
    }

    @Test
    public void testDefaultAggregation() throws Exception {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>(4);
        queryParams.put("get", Collections.singletonList("abc.metric1"));
        HandlerRequest request = new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), this.handler.getMessageHeaders().getUnresolvedMessageParameters(), this.pathParameters, queryParams);
        AggregatedMetricsResponseBody response = (AggregatedMetricsResponseBody)this.handler.handleRequest(request, (RestfulGateway)MOCK_DISPATCHER_GATEWAY).get();
        Collection aggregatedMetrics = response.getMetrics();
        Assert.assertEquals((long)1L, (long)aggregatedMetrics.size());
        AggregatedMetric aggregatedMetric = (AggregatedMetric)aggregatedMetrics.iterator().next();
        Assert.assertEquals((Object)"abc.metric1", (Object)aggregatedMetric.getId());
        Assert.assertEquals((double)1.0, (double)aggregatedMetric.getMin(), (double)0.1);
        Assert.assertEquals((double)3.0, (double)aggregatedMetric.getMax(), (double)0.1);
        Assert.assertEquals((double)2.0, (double)aggregatedMetric.getAvg(), (double)0.1);
        Assert.assertEquals((double)4.0, (double)aggregatedMetric.getSum(), (double)0.1);
    }

    static {
        TIMEOUT = Time.milliseconds((long)50L);
        TEST_HEADERS = Collections.emptyMap();
        EXECUTOR = TestingUtils.defaultExecutor();
        TEST_REST_ADDRESS = CompletableFuture.completedFuture("localhost:12345");
        MOCK_DISPATCHER_GATEWAY = (DispatcherGateway)PowerMockito.mock(DispatcherGateway.class);
        LEADER_RETRIEVER = new GatewayRetriever<DispatcherGateway>(){

            public CompletableFuture<DispatcherGateway> getFuture() {
                return CompletableFuture.completedFuture(MOCK_DISPATCHER_GATEWAY);
            }
        };
    }
}

