/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.router;

import java.util.Set;
import org.apache.flink.runtime.rest.handler.router.RouteResult;
import org.apache.flink.runtime.rest.handler.router.Router;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMethod;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RouterTest {
    private Router<String> router;

    @Before
    public void setUp() {
        this.router = StringRouter.create();
    }

    @Test
    public void testIgnoreSlashesAtBothEnds() {
        Assert.assertEquals((Object)"index", (Object)this.router.route(HttpMethod.GET, "articles").target());
        Assert.assertEquals((Object)"index", (Object)this.router.route(HttpMethod.GET, "/articles").target());
        Assert.assertEquals((Object)"index", (Object)this.router.route(HttpMethod.GET, "//articles").target());
        Assert.assertEquals((Object)"index", (Object)this.router.route(HttpMethod.GET, "articles/").target());
        Assert.assertEquals((Object)"index", (Object)this.router.route(HttpMethod.GET, "articles//").target());
        Assert.assertEquals((Object)"index", (Object)this.router.route(HttpMethod.GET, "/articles/").target());
        Assert.assertEquals((Object)"index", (Object)this.router.route(HttpMethod.GET, "//articles//").target());
    }

    @Test
    public void testEmptyParams() {
        RouteResult routed = this.router.route(HttpMethod.GET, "/articles");
        Assert.assertEquals((Object)"index", (Object)routed.target());
        Assert.assertEquals((long)0L, (long)routed.pathParams().size());
    }

    @Test
    public void testParams() {
        RouteResult routed = this.router.route(HttpMethod.GET, "/articles/123");
        Assert.assertEquals((Object)"show", (Object)routed.target());
        Assert.assertEquals((long)1L, (long)routed.pathParams().size());
        Assert.assertEquals((Object)"123", routed.pathParams().get("id"));
    }

    @Test
    public void testNone() {
        RouteResult routed = this.router.route(HttpMethod.GET, "/noexist");
        Assert.assertEquals((Object)"404", (Object)routed.target());
    }

    @Test
    public void testSplatWildcard() {
        RouteResult routed = this.router.route(HttpMethod.GET, "/download/foo/bar.png");
        Assert.assertEquals((Object)"download", (Object)routed.target());
        Assert.assertEquals((long)1L, (long)routed.pathParams().size());
        Assert.assertEquals((Object)"foo/bar.png", routed.pathParams().get("*"));
    }

    @Test
    public void testOrder() {
        RouteResult routed1 = this.router.route(HttpMethod.GET, "/articles/new");
        Assert.assertEquals((Object)"new", (Object)routed1.target());
        Assert.assertEquals((long)0L, (long)routed1.pathParams().size());
        RouteResult routed2 = this.router.route(HttpMethod.GET, "/articles/123");
        Assert.assertEquals((Object)"show", (Object)routed2.target());
        Assert.assertEquals((long)1L, (long)routed2.pathParams().size());
        Assert.assertEquals((Object)"123", routed2.pathParams().get("id"));
        RouteResult routed3 = this.router.route(HttpMethod.GET, "/notfound");
        Assert.assertEquals((Object)"404", (Object)routed3.target());
        Assert.assertEquals((long)0L, (long)routed3.pathParams().size());
        RouteResult routed4 = this.router.route(HttpMethod.GET, "/articles/overview");
        Assert.assertEquals((Object)"overview", (Object)routed4.target());
        Assert.assertEquals((long)0L, (long)routed4.pathParams().size());
        RouteResult routed5 = this.router.route(HttpMethod.GET, "/articles/overview/detailed");
        Assert.assertEquals((Object)"detailed", (Object)routed5.target());
        Assert.assertEquals((long)0L, (long)routed5.pathParams().size());
    }

    @Test
    public void testAnyMethod() {
        RouteResult routed1 = this.router.route(HttpMethod.GET, "/anyMethod");
        Assert.assertEquals((Object)"anyMethod", (Object)routed1.target());
        Assert.assertEquals((long)0L, (long)routed1.pathParams().size());
        RouteResult routed2 = this.router.route(HttpMethod.POST, "/anyMethod");
        Assert.assertEquals((Object)"anyMethod", (Object)routed2.target());
        Assert.assertEquals((long)0L, (long)routed2.pathParams().size());
    }

    @Test
    public void testRemoveByPathPattern() {
        this.router.removePathPattern("/articles");
        RouteResult routed = this.router.route(HttpMethod.GET, "/articles");
        Assert.assertEquals((Object)"404", (Object)routed.target());
    }

    @Test
    public void testAllowedMethods() {
        Assert.assertEquals((long)9L, (long)this.router.allAllowedMethods().size());
        Set methods = this.router.allowedMethods("/articles");
        Assert.assertEquals((long)2L, (long)methods.size());
        Assert.assertTrue((boolean)methods.contains(HttpMethod.GET));
        Assert.assertTrue((boolean)methods.contains(HttpMethod.POST));
    }

    @Test
    public void testSubclasses() {
        Router router = new Router().addRoute(HttpMethod.GET, "/articles", Index.class).addRoute(HttpMethod.GET, "/articles/:id", Show.class);
        RouteResult routed1 = router.route(HttpMethod.GET, "/articles");
        RouteResult routed2 = router.route(HttpMethod.GET, "/articles/123");
        Assert.assertNotNull((Object)routed1);
        Assert.assertNotNull((Object)routed2);
        Assert.assertEquals(Index.class, (Object)routed1.target());
        Assert.assertEquals(Show.class, (Object)routed2.target());
    }

    private class Show
    implements Action {
        private Show() {
        }
    }

    private class Index
    implements Action {
        private Index() {
        }
    }

    private static interface Action {
    }

    private static final class StringRouter {
        private StringRouter() {
        }

        static Router<String> create() {
            return new Router().addGet("/articles", (Object)"index").addGet("/articles/new", (Object)"new").addGet("/articles/overview", (Object)"overview").addGet("/articles/overview/detailed", (Object)"detailed").addGet("/articles/:id", (Object)"show").addGet("/articles/:id/:format", (Object)"show").addPost("/articles", (Object)"post").addPatch("/articles/:id", (Object)"patch").addDelete("/articles/:id", (Object)"delete").addAny("/anyMethod", (Object)"anyMethod").addGet("/download/:*", (Object)"download").notFound((Object)"404");
        }
    }
}

