/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.scheduler.SchedulerUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

public class SchedulerUtilsTest
extends TestLogger {
    @Test
    public void testSettingMaxNumberOfCheckpointsToRetain() throws Exception {
        int maxNumberOfCheckpointsToRetain = 10;
        Configuration jobManagerConfig = new Configuration();
        jobManagerConfig.setInteger(CheckpointingOptions.MAX_RETAINED_CHECKPOINTS, 10);
        CompletedCheckpointStore completedCheckpointStore = SchedulerUtils.createCompletedCheckpointStore((Configuration)jobManagerConfig, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (CheckpointRecoveryFactory)new StandaloneCheckpointRecoveryFactory(), (Logger)this.log, (JobID)new JobID());
        Assert.assertEquals((long)10L, (long)completedCheckpointStore.getMaxNumberOfRetainedCheckpoints());
    }
}

