/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.stream.StreamSupport;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.BlockerSync;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptorBuilder;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.io.network.NettyShuffleEnvironmentBuilder;
import org.apache.flink.runtime.io.network.partition.TestingTaskExecutorPartitionTracker;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobmaster.AllocatedSlotInfo;
import org.apache.flink.runtime.jobmaster.AllocatedSlotReport;
import org.apache.flink.runtime.jobmaster.JMTMRegistrationSuccess;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.utils.TestingJobMasterGateway;
import org.apache.flink.runtime.jobmaster.utils.TestingJobMasterGatewayBuilder;
import org.apache.flink.runtime.leaderretrieval.SettableLeaderRetrievalService;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.TestingRpcServiceResource;
import org.apache.flink.runtime.shuffle.ShuffleEnvironment;
import org.apache.flink.runtime.taskexecutor.ExecutionDeploymentReport;
import org.apache.flink.runtime.taskexecutor.JobLeaderService;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.SlotStatus;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TaskExecutorRegistrationSuccess;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceSpec;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceUtils;
import org.apache.flink.runtime.taskexecutor.TaskManagerConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesBuilder;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutor;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotUtils;
import org.apache.flink.runtime.taskmanager.UnresolvedTaskManagerLocation;
import org.apache.flink.runtime.util.TestingFatalErrorHandlerResource;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.TriFunction;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class TaskExecutorExecutionDeploymentReconciliationTest
extends TestLogger {
    private static final Time timeout = Time.seconds((long)10L);
    private final TestingHighAvailabilityServices haServices = new TestingHighAvailabilityServices();
    private final SettableLeaderRetrievalService jobManagerLeaderRetriever = new SettableLeaderRetrievalService();
    private final SettableLeaderRetrievalService resourceManagerLeaderRetriever = new SettableLeaderRetrievalService();
    private final JobID jobId = new JobID();
    @ClassRule
    public static final TestingRpcServiceResource RPC_SERVICE_RESOURCE = new TestingRpcServiceResource();
    @Rule
    public final TestingFatalErrorHandlerResource testingFatalErrorHandlerResource = new TestingFatalErrorHandlerResource();

    @Before
    public void setup() {
        this.haServices.setResourceManagerLeaderRetriever(this.resourceManagerLeaderRetriever);
        this.haServices.setJobMasterLeaderRetriever(this.jobId, this.jobManagerLeaderRetriever);
    }

    @After
    public void shutdown() {
        RPC_SERVICE_RESOURCE.getTestingRpcService().clearGateways();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeployedExecutionReporting() throws Exception {
        OneShotLatch slotOfferLatch = new OneShotLatch();
        ArrayBlockingQueue<Set<ExecutionAttemptID>> deployedExecutionsQueue = new ArrayBlockingQueue<Set<ExecutionAttemptID>>(3);
        CompletableFuture<Void> taskFinishedFuture = new CompletableFuture<Void>();
        ResourceID jobManagerResourceId = ResourceID.generate();
        TestingJobMasterGateway jobMasterGateway = TaskExecutorExecutionDeploymentReconciliationTest.setupJobManagerGateway(slotOfferLatch, deployedExecutionsQueue, taskFinishedFuture, jobManagerResourceId);
        CompletableFuture<SlotReport> initialSlotReportFuture = new CompletableFuture<SlotReport>();
        TestingResourceManagerGateway testingResourceManagerGateway = TaskExecutorExecutionDeploymentReconciliationTest.setupResourceManagerGateway(initialSlotReportFuture);
        TaskManagerServices taskManagerServices = new TaskManagerServicesBuilder().setTaskSlotTable(TaskSlotUtils.createTaskSlotTable(1, timeout)).setShuffleEnvironment((ShuffleEnvironment<?, ?>)new NettyShuffleEnvironmentBuilder().build()).build();
        TestingTaskExecutor taskExecutor = this.createTestingTaskExecutor(taskManagerServices);
        try {
            taskExecutor.start();
            taskExecutor.waitUntilStarted();
            TaskExecutorGateway taskExecutorGateway = (TaskExecutorGateway)taskExecutor.getSelfGateway(TaskExecutorGateway.class);
            TaskDeploymentDescriptor taskDeploymentDescriptor = TaskExecutorExecutionDeploymentReconciliationTest.createTaskDeploymentDescriptor(this.jobId);
            this.connectComponentsAndRequestSlot(jobMasterGateway, testingResourceManagerGateway, taskExecutorGateway, taskManagerServices.getJobLeaderService(), initialSlotReportFuture, taskDeploymentDescriptor.getAllocationId());
            TestingInvokable.sync = new BlockerSync();
            slotOfferLatch.await();
            AllocatedSlotReport slotAllocationReport = new AllocatedSlotReport(this.jobId, Collections.singleton(new AllocatedSlotInfo(0, taskDeploymentDescriptor.getAllocationId())));
            taskExecutorGateway.heartbeatFromJobManager(jobManagerResourceId, slotAllocationReport);
            Assert.assertThat(deployedExecutionsQueue.take(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            taskExecutorGateway.submitTask(taskDeploymentDescriptor, jobMasterGateway.getFencingToken(), timeout).get();
            TestingInvokable.sync.awaitBlocker();
            taskExecutorGateway.heartbeatFromJobManager(jobManagerResourceId, slotAllocationReport);
            Assert.assertThat(deployedExecutionsQueue.take(), (Matcher)IsCollectionContaining.hasItem((Object)taskDeploymentDescriptor.getExecutionAttemptId()));
            TestingInvokable.sync.releaseBlocker();
            taskFinishedFuture.get();
            taskExecutorGateway.heartbeatFromJobManager(jobManagerResourceId, slotAllocationReport);
            Assert.assertThat(deployedExecutionsQueue.take(), (Matcher)IsCollectionWithSize.hasSize((int)0));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)taskExecutor, (Time)timeout);
        }
    }

    private TestingTaskExecutor createTestingTaskExecutor(TaskManagerServices taskManagerServices) throws IOException {
        Configuration configuration = new Configuration();
        return new TestingTaskExecutor((RpcService)RPC_SERVICE_RESOURCE.getTestingRpcService(), TaskManagerConfiguration.fromConfiguration((Configuration)configuration, (TaskExecutorResourceSpec)TaskExecutorResourceUtils.resourceSpecFromConfigForLocalExecution((Configuration)configuration), (String)InetAddress.getLoopbackAddress().getHostAddress()), this.haServices, taskManagerServices, ExternalResourceInfoProvider.NO_EXTERNAL_RESOURCES, new HeartbeatServices(1000L, 30000L), UnregisteredMetricGroups.createUnregisteredTaskManagerMetricGroup(), null, new BlobCacheService(configuration, (BlobView)new VoidBlobStore(), null), this.testingFatalErrorHandlerResource.getFatalErrorHandler(), new TestingTaskExecutorPartitionTracker());
    }

    private static TaskDeploymentDescriptor createTaskDeploymentDescriptor(JobID jobId) throws IOException {
        return TaskDeploymentDescriptorBuilder.newBuilder(jobId, TestingInvokable.class).build();
    }

    private static TestingJobMasterGateway setupJobManagerGateway(OneShotLatch slotOfferLatch, BlockingQueue<Set<ExecutionAttemptID>> deployedExecutionsFuture, CompletableFuture<Void> taskFinishedFuture, ResourceID jobManagerResourceId) {
        return new TestingJobMasterGatewayBuilder().setRegisterTaskManagerFunction((TriFunction<String, UnresolvedTaskManagerLocation, JobID, CompletableFuture<RegistrationResponse>>)((TriFunction)(s, location, ignored) -> CompletableFuture.completedFuture(new JMTMRegistrationSuccess(jobManagerResourceId)))).setOfferSlotsFunction((resourceID, slotOffers) -> {
            slotOfferLatch.trigger();
            return CompletableFuture.completedFuture(slotOffers);
        }).setTaskManagerHeartbeatConsumer((resourceID, taskExecutorToJobManagerHeartbeatPayload) -> {
            ExecutionDeploymentReport executionDeploymentReport = taskExecutorToJobManagerHeartbeatPayload.getExecutionDeploymentReport();
            deployedExecutionsFuture.add(executionDeploymentReport.getExecutions());
        }).setUpdateTaskExecutionStateFunction(taskExecutionState -> {
            if (taskExecutionState.getExecutionState() == ExecutionState.FINISHED) {
                taskFinishedFuture.complete(null);
            }
            return CompletableFuture.completedFuture(Acknowledge.get());
        }).build();
    }

    private static TestingResourceManagerGateway setupResourceManagerGateway(CompletableFuture<SlotReport> initialSlotReportFuture) {
        TestingResourceManagerGateway testingResourceManagerGateway = new TestingResourceManagerGateway();
        testingResourceManagerGateway.setSendSlotReportFunction(resourceIDInstanceIDSlotReportTuple3 -> {
            initialSlotReportFuture.complete((SlotReport)resourceIDInstanceIDSlotReportTuple3.f2);
            return CompletableFuture.completedFuture(Acknowledge.get());
        });
        testingResourceManagerGateway.setRegisterTaskExecutorFunction(input -> CompletableFuture.completedFuture(new TaskExecutorRegistrationSuccess(new InstanceID(), testingResourceManagerGateway.getOwnResourceId(), new ClusterInformation("blobServerHost", 55555))));
        return testingResourceManagerGateway;
    }

    private void connectComponentsAndRequestSlot(JobMasterGateway jobMasterGateway, ResourceManagerGateway resourceManagerGateway, TaskExecutorGateway taskExecutorGateway, JobLeaderService jobLeaderService, CompletableFuture<SlotReport> initialSlotReportFuture, AllocationID allocationId) throws Exception {
        String jobMasterAddress = "jm";
        RPC_SERVICE_RESOURCE.getTestingRpcService().registerGateway("jm", (RpcGateway)jobMasterGateway);
        RPC_SERVICE_RESOURCE.getTestingRpcService().registerGateway(resourceManagerGateway.getAddress(), (RpcGateway)resourceManagerGateway);
        jobLeaderService.addJob(this.jobId, "jm");
        this.jobManagerLeaderRetriever.notifyListener("jm", UUID.randomUUID());
        this.resourceManagerLeaderRetriever.notifyListener(resourceManagerGateway.getAddress(), ((ResourceManagerId)resourceManagerGateway.getFencingToken()).toUUID());
        Optional slotStatusOptional = StreamSupport.stream(initialSlotReportFuture.get().spliterator(), false).findAny();
        Assert.assertTrue((boolean)slotStatusOptional.isPresent());
        taskExecutorGateway.requestSlot(((SlotStatus)slotStatusOptional.get()).getSlotID(), this.jobId, allocationId, ResourceProfile.ZERO, "jm", (ResourceManagerId)resourceManagerGateway.getFencingToken(), timeout).get();
    }

    public static class TestingInvokable
    extends AbstractInvokable {
        static BlockerSync sync;

        public TestingInvokable(Environment environment) {
            super(environment);
        }

        public void invoke() throws Exception {
            sync.block();
        }
    }
}

