/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.List;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.util.Preconditions;

class CheckpointPlan {
    private final List<Execution> tasksToTrigger;
    private final List<Execution> tasksToWaitFor;
    private final List<ExecutionVertex> tasksToCommitTo;
    private final List<Execution> finishedTasks;
    private final List<ExecutionJobVertex> fullyFinishedJobVertex;

    CheckpointPlan(List<Execution> tasksToTrigger, List<Execution> tasksToWaitFor, List<ExecutionVertex> tasksToCommitTo, List<Execution> finishedTasks, List<ExecutionJobVertex> fullyFinishedJobVertex) {
        this.tasksToTrigger = (List)Preconditions.checkNotNull(tasksToTrigger);
        this.tasksToWaitFor = (List)Preconditions.checkNotNull(tasksToWaitFor);
        this.tasksToCommitTo = (List)Preconditions.checkNotNull(tasksToCommitTo);
        this.finishedTasks = (List)Preconditions.checkNotNull(finishedTasks);
        this.fullyFinishedJobVertex = (List)Preconditions.checkNotNull(fullyFinishedJobVertex);
    }

    List<Execution> getTasksToTrigger() {
        return this.tasksToTrigger;
    }

    List<Execution> getTasksToWaitFor() {
        return this.tasksToWaitFor;
    }

    List<ExecutionVertex> getTasksToCommitTo() {
        return this.tasksToCommitTo;
    }

    public List<Execution> getFinishedTasks() {
        return this.finishedTasks;
    }

    public List<ExecutionJobVertex> getFullyFinishedJobVertex() {
        return this.fullyFinishedJobVertex;
    }
}

