/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManagerId;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceAllocationResult;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceAllocationStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerUtils;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerInfo;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerResourceInfoProvider;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.apache.flink.runtime.util.ResourceCounter;
import org.apache.flink.util.Preconditions;

public class DefaultResourceAllocationStrategy
implements ResourceAllocationStrategy {
    private final ResourceProfile defaultSlotResourceProfile;
    private final ResourceProfile totalResourceProfile;
    private final int numSlotsPerWorker;

    public DefaultResourceAllocationStrategy(ResourceProfile totalResourceProfile, int numSlotsPerWorker) {
        this.totalResourceProfile = totalResourceProfile;
        this.numSlotsPerWorker = numSlotsPerWorker;
        this.defaultSlotResourceProfile = SlotManagerUtils.generateDefaultSlotResourceProfile(totalResourceProfile, numSlotsPerWorker);
    }

    @Override
    public ResourceAllocationResult tryFulfillRequirements(Map<JobID, Collection<ResourceRequirement>> missingResources, TaskManagerResourceInfoProvider taskManagerResourceInfoProvider) {
        ResourceAllocationResult.Builder resultBuilder = ResourceAllocationResult.builder();
        Map<InstanceID, Tuple2<ResourceProfile, ResourceProfile>> registeredResources = DefaultResourceAllocationStrategy.getRegisteredResources(taskManagerResourceInfoProvider);
        Map<PendingTaskManagerId, ResourceProfile> pendingResources = DefaultResourceAllocationStrategy.getPendingResources(taskManagerResourceInfoProvider);
        for (Map.Entry<JobID, Collection<ResourceRequirement>> resourceRequirements : missingResources.entrySet()) {
            JobID jobId = resourceRequirements.getKey();
            ResourceCounter unfulfilledJobRequirements = DefaultResourceAllocationStrategy.tryFulfillRequirementsForJobWithRegisteredResources(jobId, resourceRequirements.getValue(), registeredResources, resultBuilder);
            if (unfulfilledJobRequirements.isEmpty()) continue;
            this.tryFulfillRequirementsForJobWithPendingResources(jobId, unfulfilledJobRequirements, pendingResources, resultBuilder);
        }
        return resultBuilder.build();
    }

    private static Map<InstanceID, Tuple2<ResourceProfile, ResourceProfile>> getRegisteredResources(TaskManagerResourceInfoProvider taskManagerResourceInfoProvider) {
        return taskManagerResourceInfoProvider.getRegisteredTaskManagers().stream().collect(Collectors.toMap(TaskManagerInfo::getInstanceId, taskManager -> Tuple2.of((Object)taskManager.getAvailableResource(), (Object)taskManager.getDefaultSlotResourceProfile())));
    }

    private static Map<PendingTaskManagerId, ResourceProfile> getPendingResources(TaskManagerResourceInfoProvider taskManagerResourceInfoProvider) {
        return taskManagerResourceInfoProvider.getPendingTaskManagers().stream().collect(Collectors.toMap(PendingTaskManager::getPendingTaskManagerId, PendingTaskManager::getTotalResourceProfile));
    }

    private static ResourceCounter tryFulfillRequirementsForJobWithRegisteredResources(JobID jobId, Collection<ResourceRequirement> missingResources, Map<InstanceID, Tuple2<ResourceProfile, ResourceProfile>> registeredResources, ResourceAllocationResult.Builder resultBuilder) {
        ResourceCounter outstandingRequirements = ResourceCounter.empty();
        for (ResourceRequirement resourceRequirement : missingResources) {
            int numMissingRequirements = DefaultResourceAllocationStrategy.tryFindSlotsForRequirement(jobId, resourceRequirement, registeredResources, resultBuilder);
            if (numMissingRequirements <= 0) continue;
            outstandingRequirements = outstandingRequirements.add(resourceRequirement.getResourceProfile(), numMissingRequirements);
        }
        return outstandingRequirements;
    }

    private static int tryFindSlotsForRequirement(JobID jobId, ResourceRequirement resourceRequirement, Map<InstanceID, Tuple2<ResourceProfile, ResourceProfile>> registeredResources, ResourceAllocationResult.Builder resultBuilder) {
        Optional<InstanceID> matchedTaskManager;
        int numUnfulfilled;
        ResourceProfile requiredResource = resourceRequirement.getResourceProfile();
        for (numUnfulfilled = resourceRequirement.getNumberOfRequiredSlots(); numUnfulfilled > 0 && (matchedTaskManager = DefaultResourceAllocationStrategy.findMatchingTaskManager(requiredResource, registeredResources)).isPresent(); --numUnfulfilled) {
            ResourceProfile effectiveProfile = SlotManagerUtils.getEffectiveResourceProfile(requiredResource, (ResourceProfile)registeredResources.get((Object)((Object)matchedTaskManager.get())).f1);
            resultBuilder.addAllocationOnRegisteredResource(jobId, matchedTaskManager.get(), effectiveProfile);
            DefaultResourceAllocationStrategy.deductionRegisteredResource(registeredResources, matchedTaskManager.get(), effectiveProfile);
        }
        return numUnfulfilled;
    }

    private static Optional<InstanceID> findMatchingTaskManager(ResourceProfile requirement, Map<InstanceID, Tuple2<ResourceProfile, ResourceProfile>> registeredResources) {
        return registeredResources.entrySet().stream().filter(taskManager -> DefaultResourceAllocationStrategy.canFulfillRequirement(SlotManagerUtils.getEffectiveResourceProfile(requirement, (ResourceProfile)((Tuple2)taskManager.getValue()).f1), (ResourceProfile)((Tuple2)taskManager.getValue()).f0)).findAny().map(Map.Entry::getKey);
    }

    private static boolean canFulfillRequirement(ResourceProfile requirement, ResourceProfile resourceProfile) {
        return resourceProfile.allFieldsNoLessThan(requirement);
    }

    private static void deductionRegisteredResource(Map<InstanceID, Tuple2<ResourceProfile, ResourceProfile>> registeredResources, InstanceID instanceId, ResourceProfile resourceProfile) {
        registeredResources.compute(instanceId, (id, tuple2) -> {
            Preconditions.checkNotNull((Object)tuple2);
            if (((ResourceProfile)tuple2.f0).subtract(resourceProfile).equals(ResourceProfile.ZERO)) {
                return null;
            }
            return Tuple2.of((Object)((ResourceProfile)tuple2.f0).subtract(resourceProfile), (Object)tuple2.f1);
        });
    }

    private static Optional<PendingTaskManagerId> findPendingManagerToFulfill(ResourceProfile resourceProfile, Map<PendingTaskManagerId, ResourceProfile> availableResources) {
        return availableResources.entrySet().stream().filter(entry -> ((ResourceProfile)entry.getValue()).allFieldsNoLessThan(resourceProfile)).findAny().map(Map.Entry::getKey);
    }

    private void tryFulfillRequirementsForJobWithPendingResources(JobID jobId, ResourceCounter unfulfilledRequirements, Map<PendingTaskManagerId, ResourceProfile> availableResources, ResourceAllocationResult.Builder resultBuilder) {
        block0: for (Map.Entry<ResourceProfile, Integer> missingResource : unfulfilledRequirements.getResourcesWithCount()) {
            ResourceProfile effectiveProfile = SlotManagerUtils.getEffectiveResourceProfile(missingResource.getKey(), this.defaultSlotResourceProfile);
            for (int i = 0; i < missingResource.getValue(); ++i) {
                Optional<PendingTaskManagerId> matchedPendingTaskManager = DefaultResourceAllocationStrategy.findPendingManagerToFulfill(effectiveProfile, availableResources);
                if (matchedPendingTaskManager.isPresent()) {
                    availableResources.compute(matchedPendingTaskManager.get(), (pendingTaskManagerId, resourceProfile) -> ((ResourceProfile)Preconditions.checkNotNull((Object)resourceProfile)).subtract(effectiveProfile));
                    resultBuilder.addAllocationOnPendingResource(jobId, matchedPendingTaskManager.get(), effectiveProfile);
                    continue;
                }
                if (this.totalResourceProfile.allFieldsNoLessThan(effectiveProfile)) {
                    PendingTaskManager pendingTaskManager = new PendingTaskManager(this.totalResourceProfile, this.numSlotsPerWorker);
                    resultBuilder.addPendingTaskManagerAllocate(pendingTaskManager);
                    resultBuilder.addAllocationOnPendingResource(jobId, pendingTaskManager.getPendingTaskManagerId(), effectiveProfile);
                    availableResources.put(pendingTaskManager.getPendingTaskManagerId(), this.totalResourceProfile.subtract(effectiveProfile));
                    continue;
                }
                resultBuilder.addUnfulfillableJob(jobId);
                continue block0;
            }
        }
    }
}

