/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metainfo;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;

public class StateMetaInfoSnapshot {
    @Nonnull
    private final String name;
    @Nonnull
    private final BackendStateType backendStateType;
    @Nonnull
    private final Map<String, String> options;
    @Nonnull
    private final Map<String, TypeSerializerSnapshot<?>> serializerSnapshots;
    @Nonnull
    private final Map<String, TypeSerializer<?>> serializers;

    public StateMetaInfoSnapshot(@Nonnull String name, @Nonnull BackendStateType backendStateType, @Nonnull Map<String, String> options, @Nonnull Map<String, TypeSerializerSnapshot<?>> serializerSnapshots) {
        this(name, backendStateType, options, serializerSnapshots, new HashMap());
    }

    public StateMetaInfoSnapshot(@Nonnull String name, @Nonnull BackendStateType backendStateType, @Nonnull Map<String, String> options, @Nonnull Map<String, TypeSerializerSnapshot<?>> serializerSnapshots, @Nonnull Map<String, TypeSerializer<?>> serializers) {
        this.name = name;
        this.backendStateType = backendStateType;
        this.options = options;
        this.serializerSnapshots = serializerSnapshots;
        this.serializers = serializers;
    }

    @Nonnull
    public BackendStateType getBackendStateType() {
        return this.backendStateType;
    }

    @Nullable
    public TypeSerializerSnapshot<?> getTypeSerializerSnapshot(@Nonnull String key) {
        return this.serializerSnapshots.get(key);
    }

    @Nullable
    public TypeSerializerSnapshot<?> getTypeSerializerSnapshot(@Nonnull CommonSerializerKeys key) {
        return this.getTypeSerializerSnapshot(key.toString());
    }

    @Nullable
    public String getOption(@Nonnull String key) {
        return this.options.get(key);
    }

    @Nullable
    public String getOption(@Nonnull CommonOptionsKeys key) {
        return this.getOption(key.toString());
    }

    @Nonnull
    public Map<String, String> getOptionsImmutable() {
        return Collections.unmodifiableMap(this.options);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Map<String, TypeSerializerSnapshot<?>> getSerializerSnapshotsImmutable() {
        return Collections.unmodifiableMap(this.serializerSnapshots);
    }

    @Nullable
    public TypeSerializer<?> getTypeSerializer(@Nonnull String key) {
        return this.serializers.get(key);
    }

    public static enum CommonSerializerKeys {
        KEY_SERIALIZER,
        NAMESPACE_SERIALIZER,
        VALUE_SERIALIZER;

    }

    public static enum CommonOptionsKeys {
        KEYED_STATE_TYPE,
        OPERATOR_STATE_DISTRIBUTION_MODE;

    }

    public static enum BackendStateType {
        KEY_VALUE,
        OPERATOR,
        BROADCAST,
        PRIORITY_QUEUE;

    }
}

