/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.SlotContext;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class SlotProfile {
    private static final SlotProfile NO_REQUIREMENTS = SlotProfile.noLocality(ResourceProfile.UNKNOWN);
    @Nonnull
    private final ResourceProfile resourceProfile;
    @Nonnull
    private final Collection<TaskManagerLocation> preferredLocations;
    @Nonnull
    private final Collection<AllocationID> priorAllocations;

    public SlotProfile(@Nonnull ResourceProfile resourceProfile, @Nonnull Collection<TaskManagerLocation> preferredLocations, @Nonnull Collection<AllocationID> priorAllocations) {
        this.resourceProfile = resourceProfile;
        this.preferredLocations = preferredLocations;
        this.priorAllocations = priorAllocations;
    }

    @Nonnull
    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    @Nonnull
    public Collection<TaskManagerLocation> getPreferredLocations() {
        return this.preferredLocations;
    }

    @Nonnull
    public Collection<AllocationID> getPriorAllocations() {
        return this.priorAllocations;
    }

    public ProfileToSlotContextMatcher matcher() {
        if (this.priorAllocations.isEmpty()) {
            return new LocalityAwareRequirementsToSlotMatcher(this.preferredLocations);
        }
        return new PreviousAllocationProfileToSlotContextMatcher(this.priorAllocations);
    }

    public static SlotProfile noRequirements() {
        return NO_REQUIREMENTS;
    }

    public static SlotProfile noLocality(ResourceProfile resourceProfile) {
        return new SlotProfile(resourceProfile, Collections.emptyList(), Collections.emptyList());
    }

    @VisibleForTesting
    public static class LocalityAwareRequirementsToSlotMatcher
    implements ProfileToSlotContextMatcher {
        private final Collection<TaskManagerLocation> locationPreferences;

        @VisibleForTesting
        public LocalityAwareRequirementsToSlotMatcher(@Nonnull Collection<TaskManagerLocation> locationPreferences) {
            this.locationPreferences = new ArrayList<TaskManagerLocation>(locationPreferences);
        }

        @Override
        public <IN, OUT> OUT findMatchWithLocality(@Nonnull Stream<IN> candidates, @Nonnull Function<IN, SlotContext> contextExtractor, @Nonnull Predicate<IN> additionalRequirementsFilter, @Nonnull BiFunction<IN, Locality, OUT> resultProducer) {
            if (this.locationPreferences.isEmpty()) {
                return candidates.filter(additionalRequirementsFilter).findFirst().map(result -> resultProducer.apply(result, Locality.UNCONSTRAINED)).orElse(null);
            }
            HashSet<ResourceID> preferredResourceIDs = new HashSet<ResourceID>(this.locationPreferences.size());
            HashSet<String> preferredFQHostNames = new HashSet<String>(this.locationPreferences.size());
            for (TaskManagerLocation locationPreference : this.locationPreferences) {
                preferredResourceIDs.add(locationPreference.getResourceID());
                preferredFQHostNames.add(locationPreference.getFQDNHostname());
            }
            Iterator iterator = candidates.iterator();
            Object matchByHostName = null;
            Object matchByAdditionalRequirements = null;
            while (iterator.hasNext()) {
                Object candidate = iterator.next();
                SlotContext slotContext = contextExtractor.apply(candidate);
                if (preferredResourceIDs.contains(slotContext.getTaskManagerLocation().getResourceID())) {
                    if (!additionalRequirementsFilter.test(candidate)) continue;
                    return resultProducer.apply(candidate, Locality.LOCAL);
                }
                if (matchByHostName != null) continue;
                if (preferredFQHostNames.contains(slotContext.getTaskManagerLocation().getFQDNHostname())) {
                    if (!additionalRequirementsFilter.test(candidate)) continue;
                    matchByHostName = candidate;
                }
                if (matchByAdditionalRequirements != null || !additionalRequirementsFilter.test(candidate)) continue;
                matchByAdditionalRequirements = candidate;
            }
            if (matchByHostName != null) {
                return resultProducer.apply(matchByHostName, Locality.HOST_LOCAL);
            }
            if (matchByAdditionalRequirements != null) {
                return resultProducer.apply(matchByAdditionalRequirements, Locality.NON_LOCAL);
            }
            return null;
        }
    }

    @VisibleForTesting
    public static class PreviousAllocationProfileToSlotContextMatcher
    implements ProfileToSlotContextMatcher {
        private final HashSet<AllocationID> priorAllocations;

        @VisibleForTesting
        PreviousAllocationProfileToSlotContextMatcher(@Nonnull Collection<AllocationID> priorAllocations) {
            this.priorAllocations = new HashSet<AllocationID>(priorAllocations);
            Preconditions.checkState((this.priorAllocations.size() > 0 ? 1 : 0) != 0, (Object)"This matcher should only be used if there are prior allocations!");
        }

        public <I, O> O findMatchWithLocality(@Nonnull Stream<I> candidates, @Nonnull Function<I, SlotContext> contextExtractor, @Nonnull Predicate<I> additionalRequirementsFilter, @Nonnull BiFunction<I, Locality, O> resultProducer) {
            Predicate<Object> filterByAllocation = candidate -> this.priorAllocations.contains((Object)((SlotContext)contextExtractor.apply(candidate)).getAllocationId());
            return candidates.filter(filterByAllocation.and(additionalRequirementsFilter)).findFirst().map(result -> resultProducer.apply(result, Locality.LOCAL)).orElse(null);
        }
    }

    public static interface ProfileToSlotContextMatcher {
        @Nullable
        public <IN, OUT> OUT findMatchWithLocality(@Nonnull Stream<IN> var1, @Nonnull Function<IN, SlotContext> var2, @Nonnull Predicate<IN> var3, @Nonnull BiFunction<IN, Locality, OUT> var4);
    }
}

