/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.runtime.blob.TransientBlobService;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rest.RestServerEndpointConfiguration;
import org.apache.flink.runtime.rest.handler.RestHandlerConfiguration;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.runtime.rest.handler.job.BlobServerPortHandler;
import org.apache.flink.runtime.rest.handler.job.JobSubmitHandler;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.webmonitor.WebMonitorEndpoint;
import org.apache.flink.runtime.webmonitor.WebMonitorExtension;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceRetriever;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;

public class DispatcherRestEndpoint
extends WebMonitorEndpoint<DispatcherGateway> {
    private WebMonitorExtension webSubmissionExtension = WebMonitorExtension.empty();

    public DispatcherRestEndpoint(RestServerEndpointConfiguration endpointConfiguration, GatewayRetriever<DispatcherGateway> leaderRetriever, Configuration clusterConfiguration, RestHandlerConfiguration restConfiguration, GatewayRetriever<ResourceManagerGateway> resourceManagerRetriever, TransientBlobService transientBlobService, Executor executor, MetricQueryServiceRetriever metricQueryServiceRetriever, LeaderElectionService leaderElectionService, FatalErrorHandler fatalErrorHandler) throws IOException {
        super(endpointConfiguration, leaderRetriever, clusterConfiguration, restConfiguration, resourceManagerRetriever, transientBlobService, executor, metricQueryServiceRetriever, leaderElectionService, fatalErrorHandler);
    }

    @Override
    protected List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> initializeHandlers(CompletableFuture<String> restAddressFuture) {
        JobSubmitHandler jobSubmitHandler;
        BlobServerPortHandler blobServerPortHandler;
        List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers;
        block5: {
            handlers = super.initializeHandlers(restAddressFuture);
            Time timeout = this.restConfiguration.getTimeout();
            blobServerPortHandler = new BlobServerPortHandler(restAddressFuture, this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders);
            jobSubmitHandler = new JobSubmitHandler(restAddressFuture, this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders);
            if (this.clusterConfiguration.getBoolean(WebOptions.SUBMIT_ENABLE)) {
                try {
                    this.webSubmissionExtension = WebMonitorUtils.loadWebSubmissionExtension(this.leaderRetriever, restAddressFuture, timeout, this.responseHeaders, this.uploadDir, this.executor, this.clusterConfiguration);
                    handlers.addAll(this.webSubmissionExtension.getHandlers());
                }
                catch (FlinkException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Failed to load web based job submission extension.", (Throwable)e);
                        break block5;
                    }
                    this.log.info("Failed to load web based job submission extension. Probable reason: flink-runtime-web is not in the classpath.");
                }
            } else {
                this.log.info("Web-based job submission is not enabled.");
            }
        }
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of(blobServerPortHandler.getMessageHeaders(), (Object)((Object)blobServerPortHandler)));
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of(jobSubmitHandler.getMessageHeaders(), (Object)((Object)jobSubmitHandler)));
        return handlers;
    }

    @Override
    protected CompletableFuture<Void> shutDownInternal() {
        CompletableFuture<Void> shutdownFuture = super.shutDownInternal();
        CompletableFuture<Void> shutdownResultFuture = new CompletableFuture<Void>();
        shutdownFuture.whenComplete((ignored, throwable) -> this.webSubmissionExtension.closeAsync().whenComplete((innerIgnored, innerThrowable) -> {
            if (innerThrowable != null) {
                shutdownResultFuture.completeExceptionally(ExceptionUtils.firstOrSuppressed((Throwable)innerThrowable, (Throwable)throwable));
            } else if (throwable != null) {
                shutdownResultFuture.completeExceptionally((Throwable)throwable);
            } else {
                shutdownResultFuture.complete(null);
            }
        }));
        return shutdownResultFuture;
    }
}

