/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.nonha.embedded;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedLeaderService {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedLeaderService.class);
    private final Object lock = new Object();
    private final Executor notificationExecutor;
    private final Set<EmbeddedLeaderElectionService> allLeaderContenders;
    private final Set<EmbeddedLeaderRetrievalService> listeners;
    private EmbeddedLeaderElectionService currentLeaderProposed;
    private EmbeddedLeaderElectionService currentLeaderConfirmed;
    private UUID currentLeaderSessionId;
    private String currentLeaderAddress;
    private boolean shutdown;

    public EmbeddedLeaderService(Executor notificationsDispatcher) {
        this.notificationExecutor = (Executor)Preconditions.checkNotNull((Object)notificationsDispatcher);
        this.allLeaderContenders = new HashSet<EmbeddedLeaderElectionService>();
        this.listeners = new HashSet<EmbeddedLeaderRetrievalService>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            this.shutdownInternally(new Exception("Leader election service is shutting down"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fatalError(Throwable error) {
        LOG.error("Embedded leader election service encountered a fatal error. Shutting down service.", error);
        Object object = this.lock;
        synchronized (object) {
            this.shutdownInternally(new Exception("Leader election service is shutting down after a fatal error", error));
        }
    }

    @GuardedBy(value="lock")
    private void shutdownInternally(Exception exceptionForHandlers) {
        assert (Thread.holdsLock(this.lock));
        if (!this.shutdown) {
            this.currentLeaderProposed = null;
            this.currentLeaderConfirmed = null;
            this.currentLeaderSessionId = null;
            this.currentLeaderAddress = null;
            for (EmbeddedLeaderElectionService embeddedLeaderElectionService : this.allLeaderContenders) {
                embeddedLeaderElectionService.shutdown(exceptionForHandlers);
            }
            this.allLeaderContenders.clear();
            for (EmbeddedLeaderRetrievalService embeddedLeaderRetrievalService : this.listeners) {
                embeddedLeaderRetrievalService.shutdown(exceptionForHandlers);
            }
            this.listeners.clear();
            this.shutdown = true;
        }
    }

    public LeaderElectionService createLeaderElectionService() {
        Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"leader election service is shut down");
        return new EmbeddedLeaderElectionService();
    }

    public LeaderRetrievalService createLeaderRetrievalService() {
        Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"leader election service is shut down");
        return new EmbeddedLeaderRetrievalService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addContender(EmbeddedLeaderElectionService service, LeaderContender contender) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"leader election service is shut down");
            Preconditions.checkState((!service.running ? 1 : 0) != 0, (Object)"leader election service is already started");
            try {
                if (!this.allLeaderContenders.add(service)) {
                    throw new IllegalStateException("leader election service was added to this service multiple times");
                }
                service.contender = contender;
                service.running = true;
                this.updateLeader();
            }
            catch (Throwable t) {
                this.fatalError(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeContender(EmbeddedLeaderElectionService service) {
        Object object = this.lock;
        synchronized (object) {
            if (!service.running || this.shutdown) {
                return;
            }
            try {
                if (!this.allLeaderContenders.remove(service)) {
                    throw new IllegalStateException("leader election service does not belong to this service");
                }
                service.contender = null;
                service.running = false;
                service.isLeader = false;
                if (this.currentLeaderConfirmed == service) {
                    this.currentLeaderConfirmed = null;
                    this.currentLeaderSessionId = null;
                    this.currentLeaderAddress = null;
                }
                if (this.currentLeaderProposed == service) {
                    this.currentLeaderProposed = null;
                    this.currentLeaderSessionId = null;
                }
                this.updateLeader();
            }
            catch (Throwable t) {
                this.fatalError(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void confirmLeader(EmbeddedLeaderElectionService service, UUID leaderSessionId) {
        Object object = this.lock;
        synchronized (object) {
            if (!service.running || this.shutdown) {
                return;
            }
            try {
                if (service == this.currentLeaderProposed && this.currentLeaderSessionId.equals(leaderSessionId)) {
                    String address = service.contender.getAddress();
                    LOG.info("Received confirmation of leadership for leader {} , session={}", (Object)address, (Object)leaderSessionId);
                    this.currentLeaderConfirmed = service;
                    this.currentLeaderAddress = address;
                    this.currentLeaderProposed = null;
                    for (EmbeddedLeaderRetrievalService listener : this.listeners) {
                        this.notificationExecutor.execute(new NotifyOfLeaderCall(address, leaderSessionId, listener.listener, LOG));
                    }
                } else {
                    LOG.debug("Received confirmation of leadership for a stale leadership grant. Ignoring.");
                }
            }
            catch (Throwable t) {
                this.fatalError(t);
            }
        }
    }

    @GuardedBy(value="lock")
    private void updateLeader() {
        assert (Thread.holdsLock(this.lock));
        if (this.currentLeaderConfirmed == null && this.currentLeaderProposed == null) {
            if (this.allLeaderContenders.isEmpty()) {
                for (EmbeddedLeaderRetrievalService listener : this.listeners) {
                    this.notificationExecutor.execute(new NotifyOfLeaderCall(null, null, listener.listener, LOG));
                }
            } else {
                UUID leaderSessionId = UUID.randomUUID();
                EmbeddedLeaderElectionService leaderService = this.allLeaderContenders.iterator().next();
                this.currentLeaderSessionId = leaderSessionId;
                this.currentLeaderProposed = leaderService;
                LOG.info("Proposing leadership to contender {} @ {}", (Object)leaderService.contender, (Object)leaderService.contender.getAddress());
                this.notificationExecutor.execute(new GrantLeadershipCall(leaderService, leaderSessionId, LOG));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(EmbeddedLeaderRetrievalService service, LeaderRetrievalListener listener) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"leader election service is shut down");
            Preconditions.checkState((!service.running ? 1 : 0) != 0, (Object)"leader retrieval service is already started");
            try {
                if (!this.listeners.add(service)) {
                    throw new IllegalStateException("leader retrieval service was added to this service multiple times");
                }
                service.listener = listener;
                service.running = true;
                if (this.currentLeaderConfirmed != null) {
                    this.notificationExecutor.execute(new NotifyOfLeaderCall(this.currentLeaderAddress, this.currentLeaderSessionId, listener, LOG));
                }
            }
            catch (Throwable t) {
                this.fatalError(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(EmbeddedLeaderRetrievalService service) {
        Object object = this.lock;
        synchronized (object) {
            if (!service.running || this.shutdown) {
                return;
            }
            try {
                if (!this.listeners.remove(service)) {
                    throw new IllegalStateException("leader retrieval service does not belong to this service");
                }
                service.listener = null;
                service.running = false;
            }
            catch (Throwable t) {
                this.fatalError(t);
            }
        }
    }

    private static class GrantLeadershipCall
    implements Runnable {
        private final EmbeddedLeaderElectionService leaderElectionService;
        private final UUID leaderSessionId;
        private final Logger logger;

        GrantLeadershipCall(EmbeddedLeaderElectionService leaderElectionService, UUID leaderSessionId, Logger logger) {
            this.leaderElectionService = (EmbeddedLeaderElectionService)Preconditions.checkNotNull((Object)leaderElectionService);
            this.leaderSessionId = (UUID)Preconditions.checkNotNull((Object)leaderSessionId);
            this.logger = (Logger)Preconditions.checkNotNull((Object)logger);
        }

        @Override
        public void run() {
            this.leaderElectionService.isLeader = true;
            LeaderContender contender = this.leaderElectionService.contender;
            try {
                contender.grantLeadership(this.leaderSessionId);
            }
            catch (Throwable t) {
                this.logger.warn("Error granting leadership to contender", t);
                contender.handleError(t instanceof Exception ? (Exception)t : new Exception(t));
                this.leaderElectionService.isLeader = false;
            }
        }
    }

    private static class NotifyOfLeaderCall
    implements Runnable {
        @Nullable
        private final String address;
        @Nullable
        private final UUID leaderSessionId;
        private final LeaderRetrievalListener listener;
        private final Logger logger;

        NotifyOfLeaderCall(@Nullable String address, @Nullable UUID leaderSessionId, LeaderRetrievalListener listener, Logger logger) {
            this.address = address;
            this.leaderSessionId = leaderSessionId;
            this.listener = (LeaderRetrievalListener)Preconditions.checkNotNull((Object)listener);
            this.logger = (Logger)Preconditions.checkNotNull((Object)logger);
        }

        @Override
        public void run() {
            try {
                this.listener.notifyLeaderAddress(this.address, this.leaderSessionId);
            }
            catch (Throwable t) {
                this.logger.warn("Error notifying leader listener about new leader", t);
                this.listener.handleError(t instanceof Exception ? (Exception)t : new Exception(t));
            }
        }
    }

    private class EmbeddedLeaderRetrievalService
    implements LeaderRetrievalService {
        volatile LeaderRetrievalListener listener;
        volatile boolean running;

        private EmbeddedLeaderRetrievalService() {
        }

        @Override
        public void start(LeaderRetrievalListener listener) throws Exception {
            Preconditions.checkNotNull((Object)listener);
            EmbeddedLeaderService.this.addListener(this, listener);
        }

        @Override
        public void stop() throws Exception {
            EmbeddedLeaderService.this.removeListener(this);
        }

        public void shutdown(Exception cause) {
            if (this.running) {
                this.running = false;
                this.listener = null;
            }
        }
    }

    private class EmbeddedLeaderElectionService
    implements LeaderElectionService {
        volatile LeaderContender contender;
        volatile boolean isLeader;
        volatile boolean running;

        private EmbeddedLeaderElectionService() {
        }

        @Override
        public void start(LeaderContender contender) throws Exception {
            Preconditions.checkNotNull((Object)contender);
            EmbeddedLeaderService.this.addContender(this, contender);
        }

        @Override
        public void stop() throws Exception {
            EmbeddedLeaderService.this.removeContender(this);
        }

        @Override
        public void confirmLeaderSessionID(UUID leaderSessionID) {
            Preconditions.checkNotNull((Object)leaderSessionID);
            EmbeddedLeaderService.this.confirmLeader(this, leaderSessionID);
        }

        @Override
        public boolean hasLeadership() {
            return this.isLeader;
        }

        void shutdown(Exception cause) {
            if (this.running) {
                this.running = false;
                this.isLeader = false;
                this.contender.revokeLeadership();
                this.contender = null;
            }
        }
    }
}

